% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/niftiS4.R
\docType{methods}
\name{orientation-methods}
\alias{orientation-methods}
\alias{qform}
\alias{qform,nifti-method}
\alias{qform-methods}
\alias{sform}
\alias{sform,nifti-method}
\alias{sform-methods}
\title{Extract NIfTI 3D Image Orientation}
\usage{
sform(object)

\S4method{sform}{nifti}(object)

qform(object)

\S4method{qform}{nifti}(object)
}
\arguments{
\item{object}{is an object of class \code{nifti}.}
}
\description{
Methods that act on the \dQuote{qform} and \dQuote{sform} information in the
NIfTI header.
}
\section{Methods}{

\describe{
\item{object = "nifti"}{Extract or replace NIfTI description.}
}
}
\examples{
\dontrun{
url <- "http://nifti.nimh.nih.gov/nifti-1/data/avg152T1_LR_nifti.nii.gz"
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
download.file(url, urlfile, quiet=TRUE)
}
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
mniLR <- readNIfTI(urlfile)
sform(mniLR)
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\keyword{methods}

