% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_dr_surv.r
\name{view_dr_surv}
\alias{view_dr_surv}
\title{2D or 2D view of survival data on reduced dimension}
\usage{
view_dr_surv(x, y, censor, B = NULL, bw = NULL, FUN = "log",
  type = "2D", legend.add = TRUE, xlab = "Reduced Direction",
  ylab = "Time", zlab = "Survival")
}
\arguments{
\item{x}{A matrix or data.frame for features (continuous only). The algorithm will not scale the columns to unit variance}

\item{y}{A vector of observed time}

\item{censor}{A vector of censoring indicator}

\item{B}{The dimension reduction subspace, can only be 1 dimensional}

\item{bw}{A Kernel bandwidth (3D plot only) for approximating the survival function, default is the Silverman's formula}

\item{FUN}{A scaling function applied to the time points \code{y}. Default is \code{"log"}.}

\item{type}{\code{2D} or \code{3D} plot}

\item{legend.add}{Should legend be added (2D plot only)}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{zlab}{z axis label}
}
\description{
Produce 2D or 3D plots of right censored survival data based on a given dimension reduction space
}
\examples{
# generate some survival data
N = 100; P = 4; dataX = matrix(rnorm(N*P), N, P)
Y = exp(-1 + dataX[,1] + rnorm(N))
Censor = rbinom(N, 1, 0.8)

orthoDr.fit = orthoDr_surv(dataX, Y, Censor, ndr = 1, method = "dm")
view_dr_surv(dataX, Y, Censor, orthoDr.fit$B)
}
\references{
Sun, Q., Zhu, R., Wang, T. and Zeng, D. "Counting Process Based Dimension Reduction Method for Censored Outcomes." (2017)
\url{https://arxiv.org/abs/1704.05046}.
}
