% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_changeset_discussion.R
\name{osm_comment_changeset_discussion}
\alias{osm_comment_changeset_discussion}
\title{Comment a changeset}
\usage{
osm_comment_changeset_discussion(changeset_id, comment)
}
\arguments{
\item{changeset_id}{The id of the changeset to comment represented by a numeric or a character value.}

\item{comment}{The text of the comment to post.}
}
\value{
Returns a data frame with the changeset (same format as \code{\link[=osm_get_changesets]{osm_get_changesets()}} with \code{format = "R"}).
}
\description{
Add a comment to a changeset and subscribe to the discussion. The changeset must be closed. Requires authentication.
}
\examples{
\dontrun{
set_osmapi_connection("testing") # use the testing server
changeset <- osm_get_changesets(300626)
updated_changeset <- osm_comment_changeset_discussion(
  changeset_id = changeset$id,
  comment = "A new comment to test osmapiR"
)
updated_changeset
}
}
\seealso{
Other changeset discussion's functions: 
\code{\link{osm_hide_comment_changeset_discussion}()},
\code{\link{osm_subscribe_changeset_discussion}()}
}
\concept{changeset discussion's functions}
