% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_gps_traces.R
\name{osm_create_gpx}
\alias{osm_create_gpx}
\title{Create GPS trace}
\usage{
osm_create_gpx(
  file,
  description,
  tags,
  visibility = c("private", "public", "trackable", "identifiable")
)
}
\arguments{
\item{file}{The GPX file path containing the track points.}

\item{description}{The trace description. Cannot be empty.}

\item{tags}{A string containing tags for the trace. Can be empty.}

\item{visibility}{One of the following: \code{private}, \code{public}, \code{trackable}, \code{identifiable}. For explanations see
\href{https://www.openstreetmap.org/traces/mine}{OSM trace upload page} or
\href{https://wiki.openstreetmap.org/wiki/Visibility_of_GPS_traces}{Visibility of GPS traces}).}
}
\value{
A number representing the ID of the new gpx.
}
\description{
Use this to upload a GPX file or archive of GPX files. Requires authentication.
}
\details{
Note that for successful processing, the file must contain trackpoints (\verb{<trkpt>}), not only waypoints, and the
trackpoints must have a valid timestamp. Since the file is processed asynchronously, the call will complete
successfully even if the file cannot be processed. The file may also be a .tar, .tar.gz or .zip containing multiple
gpx files, although it will appear as a single entry in the upload log.
}
\examples{
vignette("how_to_edit_gps_traces", package = "osmapiR")
}
\seealso{
Other edit GPS traces' functions: 
\code{\link{osm_delete_gpx}()},
\code{\link{osm_update_gpx}()}
}
\concept{edit GPS traces' functions}
