% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_as_sf.R
\name{st_as_sf}
\alias{st_as_sf}
\alias{st_as_sf.osmapi_map_notes}
\alias{st_as_sf.osmapi_changesets}
\alias{st_as_sf.osmapi_gps_track}
\alias{st_as_sf.osmapi_gpx}
\title{Convert osmapiR objects to sf objects}
\usage{
st_as_sf.osmapi_map_notes(x, ...)

st_as_sf.osmapi_changesets(x, ...)

st_as_sf.osmapi_gps_track(x, format = c("line", "points"), ...)

st_as_sf.osmapi_gpx(x, format = c("lines", "points"), ...)
}
\arguments{
\item{x}{an osmapiR object.}

\item{...}{passed on to \code{st_as_sf()} from \pkg{sf} package.}

\item{format}{Format of the output. If \code{"line"} (the default), return a \code{sf} object with one \code{LINESTRING} for each
track. If \code{"points"}, return a \code{sf} with the \code{POINT}s of the track as features. See below for details.}
}
\value{
Returns a \code{sf} object from \pkg{sf} package or a list of for \code{osmapi_gpx} and \code{format = "points"}.

When x is a \code{osmapi_gps_track} or \code{osmapi_gpx} object and \code{format = "line"}, the result will have \code{XYZM} dimensions
for coordinates, elevation and time if available. In this format, time will loss the POSIXct type as only numeric
For \code{format = "points"}, the result will have \code{XY} dimensions and elevation and time will be independent columns if
available.
}
\description{
Convert osmapiR objects to sf objects
}
\examples{
note <- osm_get_notes(note_id = "2067786")
sf::st_as_sf(note)

chaset <- osm_get_changesets(changeset_id = 137595351, include_discussion = TRUE)
sf::st_as_sf(chaset)

gpx <- osm_get_points_gps(bbox = c(-0.3667545, 40.2153246, -0.3354263, 40.2364915))
sf::st_as_sf(gpx, format = "line")
sf::st_as_sf(gpx, format = "points")

\dontrun{
# Requires authentication
trk <- osm_get_data_gpx(gpx_id = 3498170, format = "R")
sf::st_as_sf(trk, format = "line")
sf::st_as_sf(trk, format = "points")
}

}
\seealso{
\code{st_as_sf()} from \pkg{sf} package.

Other methods: 
\code{\link{tags_list2wide}()}
}
\concept{methods}
