% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm-extract.R
\name{osm_multipolygons}
\alias{osm_multipolygons}
\title{Extract all \code{osm_multipolygons} from an osmdata object}
\usage{
osm_multipolygons(dat, id)
}
\arguments{
\item{dat}{An object of class \code{osmdata}}

\item{id}{OSM identification of one or more objects for which multipolygons
are to be extracted}
}
\value{
An \code{sf} Simple Features Collection of multipolygons
}
\description{
\code{id} must be of an \code{osm_point}, \code{osm_line}, or
\code{osm_polygon} object. \code{osm_multipolygons} returns any multipolygon
object(s) which contain the object specified by \code{id}.
}
\examples{
\dontrun{
# find all multipolygons which contain the single polygon called 
# "Chiswick Eyot" (which is an island).
dat <- opq ("London UK") \%>\% 
    add_feature (key="name", value="Thames", exact=FALSE) \%>\% osmdata_sf ()
id <- rownames (dat$osm_polygons [which (dat$osm_polygons$name == "Chiswick Eyot"),])
osm_multipolygons (dat, id)
# That multipolygon is the Thames itself, but note that
nrow (dat$osm_multipolygons) # = 14 multipolygon objects
nrow (osm_multipolygons (dat, id)) # = 1 - the main Thames multipolygon
}
}
