% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmIsochrone.R
\name{osrmIsochrone}
\alias{osrmIsochrone}
\title{Get a SpatialPolygonsDataFrame of Isochrones}
\usage{
osrmIsochrone(loc, breaks = seq(from = 0, to = 60, length.out = 7),
  res = 30)
}
\arguments{
\item{loc}{a numeric vector of longitude and latitude (WGS84) or a 
SpatialPointsDataFrame or a SpatialPolygonsDataFrame of the origine point.}

\item{breaks}{a numeric vector of isochrone values (in minutes).}

\item{res}{number of points used to compute isochrones, one side of the square 
grid, the total number of points will be res*res.}
}
\value{
A SpatialPolygonsDateFrame of isochrones is returned. 
The data frame of the output contains four fields: 
id (id of each polygon), min and max (minimum and maximum breaks of the polygon), 
center (central values of classes).
}
\description{
Based on \code{\link{osrmTable}}, this function buids a 
SpatialPolygonsDataFrame of isochrones.
}
\examples{
\dontrun{
# Load data
data("com")

# Get isochones with lon/lat coordinates, default breaks
iso <- osrmIsochrone(loc = c(5.936036, 49.24882))
plot(iso)
points(5.936036, 49.24882, pch = 20, col = "red")

# Map
if(require("cartography")){
  osm <- getTiles(spdf = iso, crop = TRUE, type = "osmgrayscale")
  tilesLayer(osm)
  breaks <- sort(c(unique(iso$min), max(iso$max)))
  cartography::choroLayer(spdf = iso, df = iso@data,
                          var = "center", breaks = breaks,
                          border = NA,
                          legend.pos = "topleft",legend.frame = TRUE, 
                          legend.title.txt = "Isochrones\\n(min)", 
                          add = TRUE)
}

# Get isochones with a SpatialPointsDataFrame, custom breaks
iso2 <- osrmIsochrone(loc = src[7,], breaks = seq(from = 0,to = 30, by = 5))

# Map
if(require("cartography")){
  osm2 <- getTiles(spdf = iso2, crop = TRUE, type = "osmgrayscale")
  tilesLayer(osm2)
  breaks2 <- sort(c(unique(iso2$min), max(iso2$max)))
  cartography::choroLayer(spdf = iso2, df = iso2@data,
                          var = "center", breaks = breaks2,
                          border = NA,
                          legend.pos = "topleft",legend.frame = TRUE, 
                          legend.title.txt = "Isochrones\\n(min)", 
                          add = TRUE)
}
}
}
\seealso{
\link{osrmTable}
}
