% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracer-provider-noop.R
\name{otel_span_context}
\alias{otel_span_context}
\title{An OpenTelemetry Span Context object}
\value{
Not applicable.
}
\description{
\link{otel_tracer_provider} -> \link{otel_tracer} -> \link{otel_span} -> \link{otel_span_context}
}
\details{
This is a representation of a span that can be serialized, copied to
other processes, and it can be used to create new child spans.
}
\section{Methods}{
\subsection{\code{span_context$get_span_id()}}{

Get the id of the span.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{span_context$get_span_id()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

String scalar, a span id. For invalid spans it is \link{invalid_span_id}.
}

}

\subsection{\code{span_context$get_trace_flags()}}{

Get the trace flags of a span.

See the \href{https://w3c.github.io/trace-context/#trace-flags}{specification}
for more details on trace flags.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{span_context$get_trace_flags()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

A list with entries:
\itemize{
\item \code{is_sampled}: logical flag, whether the trace of the span is sampled.
If \code{FALSE} then the caller is not recording the trace. See details in
the \href{https://w3c.github.io/trace-context/#sampled-flag}{specification}.
\item \code{is_random}: logical flag, it specifies how trace ids are generated.
See details in the \href{https://w3c.github.io/trace-context/#random-trace-id-flag}{specification}.
}
}

}

\subsection{\code{span_context$get_trace_id()}}{

Get the id of the trace the span belongs to.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{span_context$get_trace_id()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

A string scalar, a trace id. For invalid spans it is \link{invalid_trace_id}.
}

}

\subsection{\code{span_context$is_remote()}}{

Whether the span was propagated from a remote parent.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{span_context$is_remote()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

A logical scalar.
}

}

\subsection{\code{span_context$is_sampled()}}{

Whether the span is sampled. This is the same as the \code{is_sampled}
trace flags, see \code{get_trace_flags()} above.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{span_context$is_sampled()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Logical scalar.
}

}

\subsection{\code{span_context$is_valid()}}{

Whether the span is valid. Sometimes otel functions return an
invalid span or a span context referring to an invalid span. E.g.
\code{\link[=get_active_span_context]{get_active_span_context()}} does that if there is no active span.

\code{is_valid()} checks if the span is valid.

An span id of an invalid span is \link{invalid_span_id}.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{span_context$is_valid()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

A logical scalar.
}

}

\subsection{\code{span_context$to_http_headers()}}{

Serialize the span context into one or more HTTP headers that can
be transmitted to other processes or servers, to create a distributed
trace.

The other process can deserialize these headers into a span context that
can be used to create new remote spans.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{span_context$to_http_headers()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

A named character vector, the HTTP header representation of the span
context. Usually includes a \code{traceparent} header. May include other
headers.
}

}
}

\examples{
spc <- get_active_span_context()
spc$get_trace_flags()
spc$get_trace_id()
spc$get_span_id()
spc$is_remote()
spc$is_sampled()
spc$is_valid()
spc$to_http_headers()
}
\seealso{
Other low level trace API: 
\code{\link{get_default_tracer_provider}()},
\code{\link{get_tracer}()},
\code{\link{otel_span}},
\code{\link{otel_tracer}},
\code{\link{otel_tracer_provider}},
\code{\link{tracer_provider_noop}}
}
\concept{low level trace API}
