% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-connect.R
\name{otp_connect}
\alias{otp_connect}
\title{Set up and confirm a connection to an OTP instance.}
\usage{
otp_connect(hostname = "localhost", router = "default", port = 8080,
  tz = Sys.timezone(), ssl = FALSE, check = TRUE)
}
\arguments{
\item{hostname}{A string, e.g. "ec2-34-217-73-26.us-west-2.compute.amazonaws.com".
Optional, default is "localhost".}

\item{router}{A string, e.g. "UK2018". Optional, default is "default".}

\item{port}{A positive integer. Optional, default is 8080.}

\item{tz}{A string, containing the time zone of the router's graph. Optional.
This should be a valid time zone (checked against vector returned by
`OlsonNames()`). For example: "Europe/Berlin". Default is the timezone of the
current system (obtained from \code{Sys.timezone()}). Using the default will
be ok if the current system time zone is the same as the time zone of the OTP
graph.}

\item{ssl}{Logical, indicates whether to use https. Optional, default is FALSE.}

\item{check}{Logical. If TRUE connection object is only returned if OTP
instance and router are confirmed reachable. Optional, default is TRUE.}
}
\value{
Returns S3 object of class otpconnect. If \code{check} is TRUE
    and the router is not reachable the object is not returned.
}
\description{
Defines the parameters required to connect to a router on an OTP instance and,
if required, confirms that the instance and router are queryable.
}
\examples{
\dontrun{
otpcon <- otpr_connect()
otpcon <- otpr_connect(router = "UK2018",
                      ssl = TRUE)
otpcon <- otpr_connect(hostname = "ec2.us-west-2.compute.amazonaws.com",
                      router = "UK2018",
                      port = 8888,
                      ssl = TRUE)
}
}
