% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{Fps.IWKMEIV}
\alias{Fps.IWKMEIV}
\title{Logistic regression for observed treatment and instrument used for the (S)IWKMEIV estimator.}
\usage{
Fps.IWKMEIV(datalist, t0)
}
\arguments{
\item{datalist}{A list used to calculate the (S)IWKMEIV estimator including treatment named \code{a}, observed time named \code{obs.t}, censoring indicator (0, censored) named \code{delta}, and baseline covariates used to assign treatment named \code{l}. Notice that all the data in the datalist should be ordered by observed time.}

\item{t0}{A predetermined t.}
}
\value{
A list including the probability of receiving instrument given baseline covariates named \code{fzl}, the difference between fal1 and fal0 named \code{deltal}, where fal0 denotes the probability of receiving treatment given baseline covariates and instrument equaling 0, and fal1 denotes the probability of receiving treatment given baseline covariates and instrument equaling 1, and the censoring survival function given baseline covariates and treatment 1 or 0 named \code{surv.C.1} or \code{surv.C.0}.
}
\description{
Logistic regression for observed treatment and instrument used for the (S)IWKMEIV estimator.
}
\details{
More details can be found in references, \code{\link[otrKM]{IWKMEIV}}, and \code{\link[otrKM]{Genetic.optim.IWKMEIV}}.
}
\references{
{Xia, J., Zhan, Z., Zhang, J. (2022) An anti-confounding method for estimating optimal regime in a survival context using instrumental variable. Under Review.}
}
