% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outbreaker_chains_methods.R
\name{print.outbreaker_chains}
\alias{print.outbreaker_chains}
\alias{outbreaker_chains}
\alias{plot.outbreaker_chains}
\alias{summary.outbreaker_chains}
\title{Basic methods for processing outbreaker results}
\usage{
\method{print}{outbreaker_chains}(x, n_row = 3, n_col = 8, ...)

\method{plot}{outbreaker_chains}(x, y = "post", type = c("trace",
  "hist", "density", "alpha", "t_inf", "kappa", "network"), burnin = 0,
  min_support = 0.1, labels = NULL, ...)

\method{summary}{outbreaker_chains}(object, burnin = 0,
  method = c("mpa", "decycle"), ...)
}
\arguments{
\item{x}{an \code{outbreaker_chains} object as returned by \code{outbreaker}.}

\item{n_row}{the number of rows to display in head and tail; defaults to 3.}

\item{n_col}{the number of columns to display; defaults to 8.}

\item{...}{further arguments to be passed to other methods}

\item{y}{a character string indicating which element of an
\code{outbreaker_chains} object to plot}

\item{type}{a character string indicating the kind of plot to be used (see details)}

\item{burnin}{the number of iterations to be discarded as burnin}

\item{min_support}{a number between 0 and 1 indicating the minimum support of
ancestries to be plotted; only used if 'type' is 'network'}

\item{labels}{a vector of length N indicating the case labels (must be
provided in the same order used for dates of symptom onset)}

\item{object}{an \code{outbreaker_chains} object as returned by \code{outbreaker}.}

\item{method}{the method used to determine consensus ancestries. 'mpa'
(maximum posterior ancestry) simply returns the posterior ancestry with the
highest posterior support for each case, even if this includes
cycles. 'decycle' will return the maximum posterior ancestry, except when
cycles are detected, in which case the link in the cycle with the lowest
support is pruned and the tree recalculated.}
}
\description{
Several methods are defined for instances of the class
\code{outbreaker_chains}, returned by \code{\link{outbreaker}}, including:
\code{print}, \code{plot}
}
\details{
\code{type} indicates the type of graphic to plot:

\itemize{

\item \code{trace} to visualise MCMC traces for parameters or augmented data (plots the
log-likelihood by default)

\item \code{hist} to plot histograms of quantitative values

\item \code{density} to plot kernel density estimations of quantitative values

\item \code{alpha} to visualise the posterior frequency of ancestries

\item \code{network} to visualise the transmission tree; note that
 this opens up an interactive plot and requires a web browser with
 Javascript enabled; the argument `min_support` is useful to select only the
 most supported ancestries and avoid displaying too many links

\item \code{kappa} to visualise the distributions generations between cases and their
ancestor/infector

}
}
\seealso{
See \href{http://www.repidemicsconsortium.org/outbreaker2/articles/introduction.html#graphics}{introduction vignette} for detailed examples on how to visualise \code{outbreaker_chains} objects.
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
