% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{module_help}
\alias{module_help}
\title{Get help for outsider modules}
\usage{
module_help(repo, fname = NULL)
}
\arguments{
\item{repo}{Module repo}

\item{fname}{Function name}
}
\description{
Look up help files for specific outsider module functions or
whole modules.
}
\examples{
library(outsider)
if (is_outsider_ready()) {
  # simplest repo
  repo <- 'dombennett/om..hello.world'

  # is module_installed?
  if (is_module_installed(repo = repo)) {

    # get help for package
    module_help(repo = repo)
    
    # list functions available
    module_functions(repo = repo)
    
    # import
    hello_world <- module_import(fname = 'hello_world', repo = repo)
    
    # get help for function
    module_help(repo = repo, fname = 'hello_world')
    # also works
    ?hello_world

    # run function
    hello_world()
    
    # change verbosity settings
    
    # print nothing to console
    verbosity_set(show_program = FALSE, show_docker = FALSE)
    hello_world()
    
    # print everything to console
    verbosity_set(show_program = TRUE, show_docker = TRUE)
    hello_world()
    
    # write program output to a file
    log_file <- tempfile()
    verbosity_set(show_program = log_file, show_docker = FALSE)
    
    hello_world()
    
    (readLines(con = log_file))
    
    # Clean up
    file.remove(log_file)
  }
}
}
\seealso{
Other public: 
\code{\link{is_module_installed}()},
\code{\link{module_details}()},
\code{\link{module_functions}()},
\code{\link{module_import}()},
\code{\link{module_installed}()},
\code{\link{module_install}()},
\code{\link{module_search}()},
\code{\link{module_uninstall}()}
}
\concept{public}
