% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{module_search}
\alias{module_search}
\title{Search for available outsider modules}
\usage{
module_search(service = c("github", "gitlab"))
}
\arguments{
\item{service}{Code-sharing service, e.g. GitHub}
}
\value{
Character vector
}
\description{
Return a list of available outsider modules. (Not possible for
BitBucket.)
}
\details{
Note: To search GitLab an access token is required. To create one:
1. Visit the personal access tokens section of your GitLab profile
\url{https://about.gitlab.com/}
2. Create a new token with api scope
3. Save the generated token to .Renviron
(try \code{usethis::edit_r_environ()}) with the line
"\code{GITLAB_PAT=your access token}"

For increased search relaiability, a token can be created for GitHub as well.
Visit \url{https://github.com/settings/tokens} to create a token and save
it to .Renviron as "GITHUB_PAT".
}
\examples{
library(outsider)
# return table of ALL available modules on GitHub
# NOT RUN - takes too long
\dontrun{
  (available_modules <- module_search())
}

# look-up specific modules
repo <- 'dombennett/om..goodbye.world'
(suppressWarnings(module_details(repo = repo))) # no module exists, expect warning
repo <- 'dombennett/om..hello.world'
(module_details(repo = repo))
}
\seealso{
Other public: 
\code{\link{is_module_installed}()},
\code{\link{module_details}()},
\code{\link{module_functions}()},
\code{\link{module_help}()},
\code{\link{module_import}()},
\code{\link{module_installed}()},
\code{\link{module_install}()},
\code{\link{module_uninstall}()}
}
\concept{public}
