% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouxy.r
\name{ougbmprior}
\alias{ougbmprior}
\title{Draw prior samples for ougbm model}
\usage{
ougbmprior(
  prior.model.params = prior.model.params,
  prior.reg.params = prior.reg.params
)
}
\arguments{
\item{prior.model.params}{A vectors of hyper parameters for model parameter containing (alpha.y.min, alpha.y.max) for alpha.y, (sigmasq.x.min, sigmasq.x.max) for sigmasq.x, (tau.y.min, tau.max) for rate parameter of tau}

\item{prior.reg.params}{A vector of hyper paramter for regression parameters. (b0.min,b0.max) for b0, (b1.min,b1.max) for b1,  (b2.min,b2.max) for b2}
}
\value{
Returns the  samples of model parameters and regression parameter
}
\description{
Simulate sample for parameters in ougbm model given a set of hyper parameters
}
\details{
The function requires user to input hyper parameters for \eqn{\alpha_y, \sigma^2_x,\tau} and hyper parameters for regression parameters \eqn{b_0,b_1,b_2} from uniform distribution with its minimum and maximum values.
}
\examples{

prior.model.params<-c(0,3,0,3,0,1)

names(prior.model.params)<-c("alpha.y.min","alpha.y.max",

"tau.min","tau.max","sigmasq.x.min","sigmasq.x.max")

prior.reg.params<-c(-3, 3, -3, 3, -3, 3)
names(prior.reg.params)<-c("b0.min", "b0.max", "b1.min", "b1.max", "b2.min", "b2.max")
ougbmprior(prior.model.params=prior.model.params,prior.reg.params=prior.reg.params)


}
