% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data_action}
\alias{get_data_action}
\alias{get_data_actions}
\title{Get policy actions data from JSON}
\usage{
get_data_action(json)

get_data_actions(json)
}
\arguments{
\item{json}{A JSON string, URL or file created using \code{\link[=get_json_actions]{get_json_actions()}} or
a vector of JSON strings or URLs.}
}
\value{
A tibble of policy actions with their respective policy values for
specified country/countries and specified date/dates.
}
\description{
Get policy actions data from JSON
}
\examples{
## Get relevant JSON for Afghanistan on 16 July 2020
x <- get_json_actions(ccode = "AFG", from = NULL, to = "2020-07-16")

## Get data on policy actions
get_data_action(x)

## Get relevant JSON for Afghanistan and Philippines for whole month of
## October
x <- get_json_actions(ccode = c("AFG", "PH"),
                      from = "2020-10-29",
                      to = "2020-10-31")

## Get data on policy actions
get_data_actions(x)

}
