% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_json.R
\name{get_json_time}
\alias{get_json_time}
\alias{get_json_actions}
\title{Get JSON for OxCGRT data}
\usage{
get_json_time(from = "2020-01-02", to = Sys.Date())

get_json_actions(ccode, from = "2020-01-02", to = Sys.Date())
}
\arguments{
\item{from}{Start date for stringency index data to be collected. This can go
as far back as \strong{2020-01-02} (Default). Format \code{YYYY-MM-DD}. Accepts
either character string or \code{date} class.}

\item{to}{End data for stringency index data to be collected. This defaults
to current date. Format \code{YYYY-MM-DD}. Accepts either character string or
\code{date} class.}

\item{ccode}{\strong{ISO 3166-1 alpha-2} country code, \strong{alpha-3} country code,
or full \strong{country name} string or vector of strings (mix of alpha-2 code
or alpha-3 code or country names is valid).}
}
\value{
A character object for specified JSON time series endpoint, or a
character string or a character vector for specified JSON policy actions
endpoint or endpoints.
}
\description{
Get JSON for OxCGRT data
}
\examples{
## Get JSON for Afghanistan at 7 days previous to current date
get_json_actions(ccode = "AFG",
                 from = NULL,
                 to = as.character(Sys.Date() - 7))

## Get JSON for Afghanistan and Philippines from 1 October to 31 October 2020
get_json_actions(ccode = c("Afghanistan", "PH"),
                 from = "2020-10-01", to = "2020-10-31")

## Get JSON time series endpoint for all data available from OxCGRT
get_json_time()

}
\author{
Ernest Guevarra
}
