% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{PM.plot}
\alias{PM.plot}
\title{Plot a Process Mining model graph}
\usage{
PM.plot(PM.obj)
}
\arguments{
\item{PM.obj}{a Process Mining model previously instantiated via the appropriate class (in example \code{alphaAlgorithm()}  or \code{firstOrderMarkovModel()}) or \code{AA.builder();} wrapper function}
}
\description{
This function wraps the \code{<object>::plot( ... )} method and plots the graph of a Process Mining model.
}
\examples{
\dontrun{
# Instantiate a'firstOrderMarkovModel' model
obj.LD<-LD.builder()

# Load a CSV into the loader
LD.load.csv(loader.obj = obj.LD ,nomeFile = "../csv/dati_retto.csv",
        IDName = "CODICE_SANITARIO_ADT",EVENTName = "CAT1")

# Instantiate a PM model
obj.PM <-PM.builder(kindOfObject = "firstOrderMarkovModel")

# Load the PM model
PM.loadDataset(PM.obj = obj.PM,dataList = LD.getData(loader.obj = obj.LD))

# train it
PM.trainModel(PM.obj = obj.PM)#' 

# plot the model
PM.plot(PM.obj = obj.PM)
}  
}

