% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstOrderMarkovModel.R
\name{firstOrderMarkovModel}
\alias{firstOrderMarkovModel}
\title{A class to train First Order Markov Models}
\usage{
firstOrderMarkovModel(parameters.list = list())
}
\arguments{
\item{parameters.list}{a list containing the parameters. The possible ones are: 'considerAutoLoop' and 'threshold'. 'considerAutoLoop' is a boolean which indicates if the autoloops have to be admitted, while 'threshold' is the minimum value that a probability should have to do not be set to zero, in the transition matrix.}
}
\description{
This is an implementation of the First Order Markov Model (FOMM) for Process Mining issues.
               This class provides a minimal set of methods to handle with the FOMM model:
               \itemize{
               \item \code{firstOrderMarkovModel( ) } is the costructor
               \item \code{loadDataset( ) } loads data taken from a dataLoader::getData() method, into a FOMM object
               \item \code{trainModel( ) } train a model using the previously loaded dataset
               \item \code{replay( ) } re-play a given event log on the internal FOMM model
               \item \code{play( ) } play the internal FOMM model a desired number of times, in order to simulate new event-logs. This methods can also, if desired, simulate event-logs which does not complies with the internal FOMM model.
               \item \code{plot( ) } plot the internal model
               \item \code{distanceFrom( ) } calculate the scalar distance to another passed FOMM model, passed as argument. The default metric returns a scalar value
               \item \code{getModel( ) } return the trained internal FOMM model
               \item \code{getLogObj( ) } return an XML containing the execution-log of a \code{firstOrderMarkovModel::play()}  computation
               \item \code{getInstanceClass( ) } return the instance class Name and description (version, etc.)
               \item \code{plot.delta.graph( ) } plot a graph, in the desired modality, representing the difference between the internal FOMM and a passed one.
               \item \code{get.transition.Prob( ) } calculate the probability to go in a given number of transitions, from a state to another
               \item \code{get.time.transition.Prob( ) } calculate the probability to go in a given time, from a state to another
               \item \code{build.PWF( ) } build automatically a PWF XML definition script.
               \item \code{findReacheableNodes( ) } and return the array containing the reacheable states, starting from the passed one.
               }
             In order to better undestand the use of such methods, please visit: www.pminer.info
             
             The consturctor admit the following parameters:
parameters.list a list containing possible parameters to tune the model.
}
\examples{
\dontrun{

# create a Loader
obj.L<-dataLoader();   

# Load a .csv 
obj.L$load.csv(nomeFile = "../otherFiles/mammella.csv",
IDName = "CODICE_SANITARIO_ADT",
EVENTName = "DESC_REPARTO_RICOVERO",
dateColumnName = "DATA_RICOVERO")

# get the loaded data
dati <- obj.L$getData()

# build a Second Order Marvov Model with a threshold of 0.2
FOMM <- firstOrderMarkovModel( 
parameters.list = list("threshold"=0.001))

# load the data
FOMM$loadDataset(dataList = dati)

# train a model
FOMM$trainModel()

# generate 10 new processes (nb: if the 
# threshold is too low, it can fail...)
aaa <- FOMM$play(numberOfPlays = 10)

# get the transition matrix
TranMatrix <- FOMM$getModel(kindOfOutput = "MMatrix.perc")

# plot the model
FOMM$plot()

# generate other 20 fake-processes
ooo <- FOMM$play(numberOfPlays = 20)

}
}

