% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.dataLoader.R
\name{meta.dataLoader}
\alias{meta.dataLoader}
\title{Load the event-logs serializing many dataLoaders objs}
\usage{
meta.dataLoader(verbose.mode = TRUE)
}
\arguments{
\item{verbose.mode}{boolean. If TRUE some messages will appear in console, during the computation; otherwise the computation will be silent.}
}
\description{
This class is  more abstract than dataLoader and provide some facilities, in particular to cope with dictionaries and tranlations. Because it handles, internally, a set of dataLoader objects, any dataLoader object must be referred by 'view'.
             \itemize{
             \item \code{meta.dataLoader() } the costructor
             \item \code{load.csv( ... ) } loads the csv file into the \code{dataLoader} object
             \item \code{load.data.frame() } loads a data.frame into the \code{dataLoader} object
             \item \code{getData() } return the processed, previously-loaded, data
             \item \code{removeEvents() } remove the events in the array passed as argument (dual of \code{dataLoader::keepOnlyEvents()} )
             \item \code{keepOnlyEvents() } keep only the events in the array passed as argument (dual of \code{dataLoader::removeEvents()} )
             \item \code{addDictionary() } add a dictionary in order, afterward, to translate or group some event name
             \item \code{getTranslation() } perform a translation applying the given dictionary to the loaded csv or data.frame
             \item \code{plot.Timeline() } plot the timeline of the events regarding a single patient 
             } 
             In order to better undestand the use of such methods, please visit: www.pminer.info
             
             The consturctor admit the following parameters:
verbose.mode are some notification wished, during the computation? The defaul value is \code{true}
}
\examples{
\dontrun{

# create a Loader
obj.L<-meta.dataLoader();   

# create a view
obj.L$createView(view.name = "mammella")
obj.L$createView(view.name = "retto")

# Load a .csv into the view 'mammella'
obj.L$load.csv(nomeFile = "../otherFiles/mammella.csv",
IDName = "CODICE_SANITARIO_ADT",
EVENTName = "DESC_REPARTO_RICOVERO",
dateColumnName = "DATA_RICOVERO", view="mammella")

# Load a .csv into the view 'retto'
obj.L$load.csv(nomeFile = "../otherFiles/mammella.csv",
IDName = "CODICE_SANITARIO_ADT",
EVENTName = "DESC_REPARTO_RICOVERO",
dateColumnName = "DATA_RICOVERO", view="retto")

# get the data from the view 'retto'
aaa <- obj.L$getData(view = "retto")


}
}

