% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mon_to_year.R
\name{mon_to_year}
\alias{mon_to_year}
\title{Rescale a precipitation data product in time}
\usage{
mon_to_year(x, stat = "sum", autosave = FALSE)
}
\arguments{
\item{x}{a character string with the path to the data file. Or RasterBrick object}

\item{stat}{a character string with the desired aggregation function. Suitable options are:
\itemize{
\item "max"
\item "mean"
\item "median"
\item "min"
\item "sum" (default)
}}

\item{autosave}{logical FALSE (default). If TRUE data will be automatically stored in the same location of the input file}
}
\value{
A RasterBrick.
}
\description{
The function \code{mon_to_year} aggregates the requested data set from monthly to yearly time steps and stores it in the same location of the input file.
}
\examples{
\dontrun{
mon_to_year("gpcp_tp_mm_global_197901_202205_025_monthly.nc", autosave = TRUE)
mon_to_year("dummie.nc", autosave = TRUE)
}
}
