% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b_outcome_analysis_functions.R
\name{value_eq5d5L_IPD}
\alias{value_eq5d5L_IPD}
\title{Function to add EQ5D5L scores to IPD data}
\source{
http://eprints.whiterose.ac.uk/121473/1/Devlin_et_al-2017-Health_Economics.pdf
}
\usage{
value_eq5d5L_IPD(ind_part_data, eq5d_nrcode)
}
\arguments{
\item{ind_part_data}{a dataframe}

\item{eq5d_nrcode}{non response code for EQ5D5L, default is NA}
}
\value{
qaly included modified data, if success -1, if failure
}
\description{
Function to add EQ5D5L scores to IPD data
}
\examples{
datafile <- system.file("extdata", "trial_data.csv", package = "packDAMipd")
trial_data <- load_trial_data(datafile)
value_eq5d5L_IPD(trial_data, NA)
}
