% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devtools.R
\name{build_vignettes}
\alias{build_vignettes}
\title{Build CRAN and gh-pages vignettes}
\usage{
build_vignettes(pkg = ".", dependencies = "VignetteBuilder",
  output_dir = file.path(as.package(pkg)$path, "_gh-pages"),
  extra_dirs = file.path(as.package(pkg)$path, "vignettes",
  c(lazy_widgets_dir(), assets_dir())),
  delete_files = file.path(as.package(pkg)$path, "vignettes",
  c(".build.timestamp")), include_vignette_source = FALSE)
}
\arguments{
\item{pkg}{path to package. Provided directly to \code{devtools::\link[devtools]{as.package}()}}

\item{dependencies}{supplied directly to \code{devtools::\link[devtools]{install_deps}()}}

\item{output_dir}{directory where the fully contained vignette directory should be exported}

\item{extra_dirs}{list of directories that will be copied to the gh-pages that are not vignettes and should not be shipped with the package. Files that should be exist in both gh-pages and the package should be contained in the \code{vignettes/.install_extras} file.}

\item{delete_files}{list of files that should be deleted if they still exist when the function ends}

\item{include_vignette_source}{boolean to determine if the vignettes should be copied to the destination directory.  Default behavior is to NOT copy the original vignettes}
}
\description{
Build CRAN html redirect vignettes that are placed in inst/doc/ that redirect to the gh-pages branch of the github url provided in the DESCRIPTION file.  This function is heavily inspired by \code{devtools::\link[devtools]{build_vignettes}()}.
}

