% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packagefinder.r
\name{findPackage}
\alias{findPackage}
\title{Searching for packages on CRAN}
\usage{
findPackage(keywords, index = NULL, mode = "or", case.sensitive = FALSE,
  always.sensitive = NULL, weights = c(1, 2, 1, 2), display = "viewer",
  results.longdesc = FALSE)
}
\arguments{
\item{keywords}{A vector of keywords to be searched for.}

\item{index}{Either a path (or URL) to a search index, or a search index that is already loaded. If no index is provided, \code{findPackage} creates an ad hoc search index.}

\item{mode}{Indicates wthether the search terms in \code{keywords} shall be combined with a logical OR or with a logical AND; accordingly, permitted values are \code{"or"} (default) and \code{"and"}. In \code{"or"} mode, every package that contains \emph{at least one} of the keywords from the \code{keywords} argument is a search hit, in \code{"and"} mode generating a search hit requires \emph{all} search terms from the \code{keywords} argument to be found.}

\item{case.sensitive}{Indicates if the search shall be case sensitive, or not.}

\item{always.sensitive}{A vector of search terms for which capitalization is always considered relevant (even if \code{case.sensitive = FALSE}). This allows to better reflect abbreviations like 'GLM'.}

\item{weights}{A numeric vector describing how search hits in different fields of the a package's data shall be weighted. The first three elements of the vector are the weights assigned to hits in the package's \emph{title}, \emph{short description} and \emph{long description}, respectively. The fourth element is a factor applied to the overall score of a search hit if all search terms from the \code{keywords} argument are found (obviously only meaningful in \code{"or"} mode). All weights must be 1 or larger.}

\item{display}{Describes where the search results shall be shown. Either \code{"viewer"} or \code{"console"}. If \code{"viewer"}, the results are shown as a formatted web page in the browser (or in RStudio's Viewer pane if the RStudio IDE is being used). If \code{results = "console"} the search results are shown as a text table in the R console.}

\item{results.longdesc}{Indicates whether the packages' long descriptions shall also be included in the search results. Given the length of some long decsriptions this may make the search results harder to read.}
}
\value{
No return value.
}
\description{
Searches for packages on CRAN based on the user's specification of search terms. Considers the package name, description as well as the long description, and prioritizes the results.
}
\details{
The \code{GO} column in the search results is an index number that can be used to address the found package easily with the \code{go()} function.
The \code{DOWNL_TOTAL} column in the search results gives the overall number of downloads of the respective package since its submission to CRAN. The number is based on the figures for the RStudio CRAN mirror server.
This field is only provided if the search index contains download figures. Ad hoc indices (when \code{index = NULL}) never include download statistics. Please refer to \code{\link{buildIndex}} for more details.
}
\examples{
\donttest{
search <- "regression"
findPackage(search)

findPackage(c("text", "tables"), mode="and")

searchindex <- buildIndex()
findPackage(keywords=c("regression", "linear"), index=searchindex,
   mode="and", always.sensitive="GLM")
}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
