% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeduration.R
\name{pacs_health}
\alias{pacs_health}
\title{Packages health state at a specific Date or for a specific versions}
\usage{
pacs_health(pacs, versions = NULL, at = NULL)
}
\arguments{
\item{pacs}{character vector packages names.}

\item{versions}{character vector versions of packages. Default: NULL}

\item{at}{Date old version of package. Default: NULL}
}
\value{
logical vector, TRUE if a package is healthy.
}
\description{
using CRAN website to get a package version/versions used at a specific Date interval.
A healthy package is a if it was published for more than 14 days.
CRAN team gives around one week to resolved a package which gave errors under the check page.
}
\note{
Function will scrap two CRAN URLS. Works only with CRAN packages.
Please as a courtesy to the R CRAN, don't overload their server by constantly using this function.
Results are cached for 1 hour with \code{memoise} package, memory cache.
}
\examples{
pacs_health(c("memoise"))
pacs_health(c("memoise", "devtools"), versions = c("1.0.0", "2.4.0"))
}
