% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeduration.R
\name{pac_health}
\alias{pac_health}
\title{CRAN package health state at a specific Date or for a specific version}
\usage{
pac_health(
  pac,
  version = NULL,
  at = NULL,
  limit = 14,
  scope = c("ERROR", "FAIL"),
  flavors = NULL,
  lib.loc = .libPaths(),
  repos = "https://cran.rstudio.com/",
  source = c("crandb", "cran")
)
}
\arguments{
\item{pac}{character a package name.}

\item{version}{character package version, By default the newest version is taken. Default: NULL}

\item{at}{Date old version of package. Default: NULL}

\item{limit}{numeric at least days to treat as healthy, ">=limit". Default: 14}

\item{scope}{character vector scope of R CRAN check pages statuses to consider, any of \code{c("ERROR", "FAIL", "WARN", "NOTE")}. Default \code{c("ERROR", "FAIL")}}

\item{flavors}{character vector of CRAN machines to consider, which might be retrieved with \code{pacs::cran_flavors()$Flavor}. By default all CRAN machines are considered, NULL value. Default NULL}

\item{lib.loc}{character vector. Is omitted for non NULL version. Default: \code{.libPaths()}}

\item{repos}{character vector URLs of the repositories to use. Default \verb{https://cran.rstudio.com/}}

\item{source}{character one of \code{c("crandb", "cran")}. Using the \code{MEATCRAN} DB or the direct web page download from CRAN. Default: \code{"crandb"}}
}
\value{
logical if a package is healthy.
}
\description{
a package health for a certain version or at a specific Date.
A healthy package was published for more than x days, where default is 14 days.
CRAN team gives around one/two week to resolved a package which gave errors under the check page.
The newest release is checked for any warnings/errors on the R CRAN package check page.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
The \code{crandb} R packages database is a part of \code{METACRAN} project, source:
Csárdi G, Salmon M (2022). \code{pkgsearch}: Search and Query CRAN R Packages. \verb{https://github.com/r-hub/pkgsearch}, \verb{https://r-hub.github.io/pkgsearch/}.
For \code{source = "cran"}the function will scrap two CRAN URLS. Works only with CRAN packages.
Please as a courtesy to the R CRAN, don't overload their servers by constantly using this function.
}
\examples{
\dontrun{
pacs::pac_health("memoise")
pacs::pac_health("dplyr", version = "0.8.0", limit = 14)
pacs::pac_health("dplyr", at = as.Date("2019-02-14"))
pacs::pac_health("dplyr", limit = 14, scope = c("ERROR", "FAIL"))
}
}
