% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{lib_validate}
\alias{lib_validate}
\title{Validate the local library}
\usage{
lib_validate(
  lib.loc = .libPaths(),
  fields = c("Depends", "Imports", "LinkingTo"),
  lifeduration = FALSE,
  checkred = list(scope = character(0), flavors = NULL),
  built = FALSE,
  repos = biocran_repos()
)
}
\arguments{
\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{fields}{\code{character} vector listing the types of dependencies, a subset of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lifeduration}{\code{logical} if to assess life duration for each package in the library.
For installed newest releases of packages, a local evaluation is used.
\verb{MEATCRAN CRANDB} is used for libraries with less than 500 packages.
Otherwise the direct web page download from CRAN is used.
Default: `FALSE``}

\item{checkred}{\code{list} with two named fields, \code{scope} and \code{flavor}. \code{scope} of R CRAN check pages statuses to consider, any of \code{c("ERROR", "FAIL", "WARN", "NOTE")}.
\code{flavor} is a vector of CRAN machines to consider, which might be retrieved with \code{pacs::cran_flavors()$Flavor}.
By default an empty scope field deactivated assessment for \code{checkred} column, and NULL flavor will results in checking all machines.
Default: \code{list(scope = character(0), flavor = NULL)}}

\item{built}{\code{logical} if to add an R version under which each package was installed.
Useful mainly for a local usage.
Packages installed with a previous version of R could not work correctly with the new version of R. Default: \code{FALSE}}

\item{repos}{\code{character} vector of repositories URLs to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}
}
\value{
\code{data.frame} with 4/6/8/9/10 columns.
\describe{
\item{Package}{character a package name.}
\item{Version.expected.min}{character expected by DESCRIPTION files minimal version. "" means not specified so the newest version.}
\item{Version.have}{character installed package version.}
\item{version_status}{ numeric -1/0/1 which comes from \code{utils::compareVersion} function.
0 means that we have the same version as required by DESCRIPTION files. -1 means we have too low version installed, this is an error. 1 means we have higher version.}
\item{built}{character package was built under this R version}
\item{built_status}{integer if the package was built under the current R version, then 1 (good) and for older R versions 0 (possibly bad).
A package built under older R version or mix of packages built under different versions could bring possible failures.}
\item{newest}{logical (Internet needed) if the installed version is the newest one. For Bioconductor if is the newest one per R version.}
\item{cran}{logical (Internet needed) if the package is on CRAN, version is not taken into account here.}
\item{checkred}{(Optional) (Internet needed) logical if the NEWEST package contains any specified statuses on CRAN check page. \code{pacs::checked_packages} is used to quickly retrieve all statuses at once.}
\item{lifeduration}{(Optional) (Internet needed) integer number of days a package was released.}
}
}
\description{
Checking if installed packages have correct versions taking into account all DESCRIPTION files requirements.
Moreover identifying which packages are newest releases.
Optionally we could add life duration and CRAN check page status for each package.
}
\note{
Version.expected.min column not count packages which are not a dependency for any package, so could not be find in DESCRIPTION files.
When turn on the \code{lifeduration} options, calculations might be time consuming for libraries bigger than 500 packages.
Results are cached for 30 minutes with \code{memoise} package.
\code{BioConductor} packages are tested only in available scope, \code{checkred} is not assessed for them.
The \code{crandb} R packages database is a part of \code{METACRAN} project, source:
Csárdi G, Salmon M (2022). \code{pkgsearch}: Search and Query CRAN R Packages. \verb{https://github.com/r-hub/pkgsearch}, \verb{https://r-hub.github.io/pkgsearch/}.
}
\examples{
\dontrun{
pacs::lib_validate()
pacs::lib_validate(checkred = list(scope = c("ERROR", "FAIL", "WARN")))
pacs::lib_validate(checkred = list(
  scope = c("ERROR", "FAIL"),
  flavors = pacs::match_flavors()
))
# activate lifeduration argument, could be time consuming for bigger libraries.
pacs::lib_validate(
  lifeduration = TRUE,
  checkred = list(scope = c("ERROR", "FAIL"))
)
# only R CRAN repository
pacs::lib_validate(repos = "https://cran.rstudio.com/")
}
}
