% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{pa_plot}
\alias{pa_plot}
\alias{pa_plot.yield}
\alias{pa_plot.veg.index}
\alias{pa_plot.rgb}
\alias{pa_plot.met}
\title{Create a plot from a pacu object}
\usage{
pa_plot(x, ...)

\method{pa_plot}{yield}(
  x,
  ...,
  plot.type = c("yieldmap", "variogram"),
  palette = "Temps",
  main = "",
  plot.var = NULL,
  interactive = FALSE,
  border.col = "black",
  style = c("quantile", "pretty", "equal"),
  scale = 1,
  nbreaks = 5,
  breaks = NULL,
  frame = TRUE,
  legend.outside = FALSE
)

\method{pa_plot}{veg.index}(
  x,
  ...,
  palette = ifelse(plot.type == "timeseries", "Dark 2", "Temps"),
  plot.type = c("spatial", "timeseries"),
  main = "",
  plot.var = NULL,
  by = "year",
  xlab = NULL,
  ylab = NULL,
  style = c("quantile", "pretty", "equal"),
  nbreaks = 5,
  border.col = "black",
  frame = TRUE,
  legend.outside = FALSE,
  legend.title = NULL,
  pch = 16
)

\method{pa_plot}{rgb}(
  x,
  ...,
  interactive = FALSE,
  saturation = 1,
  alpha = 1,
  interpolate = FALSE
)

\method{pa_plot}{met}(
  x,
  ...,
  plot.type = c("climate_normals", "monthly_distributions"),
  unit.system = c("international", "standard"),
  start = 1,
  end = 365,
  months = 1:12,
  vars = c("maxt", "mint", "crain", "cradn"),
  tgt.year = "last"
)
}
\arguments{
\item{x}{object to be plotted}

\item{...}{additional arguments. None used currently.}

\item{plot.type}{type of plot to be produced Defaults to
yieldmap.}

\item{palette}{a string representing a color palette from
\link[grDevices]{hcl.pals}. Defaults to \sQuote{Temps}.}

\item{main}{a main title for the plot}

\item{plot.var}{the name of the column to be plotted.
Defaults to \sQuote{yield}}

\item{interactive}{logical. Whether to produce
interactive plots.}

\item{border.col}{color of the border for the polygons
plotted in the yield map}

\item{style}{style applied to the colors}

\item{scale}{a numerical value indicating the
magnification of the graph. A value of 1 produces a
plot using the default magnification. Greater values
will produce zoomed in plots.}

\item{nbreaks}{numerical value indicating the number of breaks for the color scale.}

\item{breaks}{a vector indicating numerical breaks for the color scale.}

\item{frame}{logical. Whether to draw the frame around
the plotting area.}

\item{legend.outside}{logical. Whether to place the legend outside of the graph.}

\item{by}{a string or vector of strings used to group the data 
when plotting. Defaults to 'year'}

\item{xlab}{a string used as label for x axis}

\item{ylab}{a string used as label for y axis}

\item{legend.title}{a string used as title for the legend}

\item{pch}{an integer indicating which shape to use for points}

\item{saturation}{numeric. Controls the image saturation. 0 maps to grayscale. 1 maps to the default value.  See \link[tmap]{tm_rgb} for details.}

\item{alpha}{numeric between 0 and 1. See \link[tmap]{tm_rgb} for details.}

\item{interpolate}{logical. Whether the raster image should be interpolated. See \link[tmap]{tm_rgb} for details.}

\item{unit.system}{unit system to be used: international
(metric) or stanrdard (imperial)}

\item{start}{day of the year to start computing the
climate normals. Defaults to 1.}

\item{end}{day of the year to finish computing the
climate normals. Defaults to 365.}

\item{months}{a numerical vector indicating which months
to produce a plot for in the case of monthly
distribution plots. Defaults to 1:12.}

\item{vars}{which variables to include in the summary
plot}

\item{tgt.year}{which year to focus and compare to the
historical mean. Defaults to the last year in the data
set.}
}
\value{
No return value, called for side effects
}
\description{
Create interactive or static plots such as yieldmaps, variograms,
and rgb images from pacu objects.
}
\examples{
\dontrun{
## for examples, please see the pacu vignette
}

}
\author{
Caio dos Santos and Fernando Miguez
}
