% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thicken.R
\name{thicken}
\alias{thicken}
\title{Add a variable of a higher interval to a data frame.}
\usage{
thicken(x, interval = c("level_up", "year", "quarter", "month", "week", "day",
  "hour", "min"), colname = NULL, rounding = c("down", "up"), by = NULL,
  start_val = NULL)
}
\arguments{
\item{x}{A data frame containing at least one datetime variable of
class \code{Date}, class \code{POSIXct} or class \code{POSIXlt}.}

\item{interval}{The interval of the added datetime variable, which should be higher
than the interval of the input datetime variable. If \code{NULL} it will be one level
higher than the interval of the input datetime variable.}

\item{colname}{The column name of the added variable. If \code{NULL} it will
be the name of the original datetime variable with the interval name added to
it, separeted by an underscore.}

\item{rounding}{Should a value in the input datetime variable be mapped to
the closest value that is lower (\code{down}) or that is higher (\code{up})
than itself.}

\item{by}{Only needs to be specified when \code{x} contains multiple
variables of class \code{Date}, class \code{POSIXct} or class \code{POSIXlt}.
\code{by} indicates which to use.}

\item{start_val}{By default the first instance of \code{interval} that is lower
than the lowest value of the input datetime variable, with all time units on
default value. Specify \code{start_val} as an offset if you want the range
to be nonstandard.}
}
\value{
The data frame \code{x} with the variable added to it.
}
\description{
\code{thicken} will take the datetime variable in a data frame and map this
to a variable of a higher interval. The mapping is added to the data frame
in a new variable. After applying \code{thicken} the user can aggregate the
other variables in the data frame to the higher interval, for instance using
\code{dplyr}.
}
\details{
See \code{vignette("padr")} for more information on \code{thicken}.
See \code{vignette("padr_implementation")} for detailed information on
daylight savings time, different timezones, and the implementation of
\code{thicken}.
}
\examples{
x_hour <- seq(lubridate::ymd_hms('20160302 000000'), by = 'hour',
              length.out = 200)
some_df <- data.frame(x_hour = x_hour)
thicken(some_df)
thicken(some_df, 'month')
thicken(some_df, start_val = lubridate::ymd_hms('20160301 120000'))

library(dplyr)
x_df <- data.frame(
  x = seq(lubridate::ymd(20130101), by = 'day', length.out = 1000) \%>\%
    sample(500),
  y = runif(500, 10, 50) \%>\% round) \%>\%
  arrange(x)

# get the max per month
x_df \%>\% thicken('month') \%>\% group_by(x_month) \%>\%
  summarise(y_max = max(y))

# get the average per week, but you want your week to start on Mondays
# instead of Sundays
min_x <- x_df$x \%>\% min
weekdays(min_x)
x_df \%>\% thicken(start_val = min_x - 1) \%>\%
  group_by(x_week) \%>\% summarise(y_avg = mean(y))
}
