% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_functions.R
\name{fill_by_prevalent}
\alias{fill_by_prevalent}
\title{Fill missing values by the most prevalent nonmissing value}
\usage{
fill_by_prevalent(x, ...)
}
\arguments{
\item{x}{A data frame.}

\item{...}{The unquoted column names of the variables that should be filled.}
}
\value{
\code{x} with the altered columns.
}
\description{
For each specified column in \code{x} replace the missing values by the most
prevalent nonmissing value.
}
\examples{
library(dplyr) # for the pipe operator
x <- seq(as.Date('2016-01-01'), by = 'day', length.out = 366)
x <- x[sample(1:366, 200)] \%>\% sort
x_df <- data_frame(x  = x,
                  y1 = rep(letters[1:3], c(80, 70, 50)) \%>\% sample,
                  y2 = rep(letters[2:5], c(60, 80, 40, 20)) \%>\% sample)
x_df \%>\% pad \%>\% fill_by_prevalent(y1, y2)
}
