% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{pkg_download}
\alias{pkg_download}
\title{Download a package and potentially its dependencies as well}
\usage{
pkg_download(
  pkg,
  dest_dir = ".",
  dependencies = FALSE,
  platforms = NULL,
  r_versions = NULL
)
}
\arguments{
\item{pkg}{Package names or remote package specifications to download.}

\item{dest_dir}{Destination directory for the packages. If it does not
exist, then it will be created.}

\item{dependencies}{Dependency types, to download the (recursive)
dependencies of \code{pkg} as well. See \code{\link[pkgdepends:as_pkg_dependencies]{pkgdepends::as_pkg_dependencies()}}
for possible values.}

\item{platforms}{Types of binary or source packages to download. The
default is the value of \code{\link[pkgdepends:default_platforms]{pkgdepends::default_platforms()}}.}

\item{r_versions}{R version(s) to download packages for. (This does not
matter for source packages, but it does for binaries.) It defaults to
the current R version.}
}
\value{
Data frame (tibble) with information about the downloaded
packages, invisibly.
}
\description{
Download a package and potentially its dependencies as well
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pkg_download("forcats")
pkg_download("r-lib/pak", platforms = "source")
\dontshow{\}) # examplesIf}
}
\seealso{
Other package functions: 
\code{\link{lib_status}()},
\code{\link{pak_package_sources}},
\code{\link{pak}()},
\code{\link{pkg_deps_tree}()},
\code{\link{pkg_deps}()},
\code{\link{pkg_install}()},
\code{\link{pkg_remove}()},
\code{\link{pkg_status}()}
}
\concept{package functions}
