% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_install}
\alias{local_install}
\title{Install a package tree}
\usage{
local_install(
  root = ".",
  lib = .libPaths()[1],
  upgrade = TRUE,
  ask = interactive(),
  dependencies = NA
)
}
\arguments{
\item{root}{Path to the package tree.}

\item{lib}{Package library to install the packages to. Note that \emph{all}
dependent packages will the be installed here, even if they are
already installed in another library.}

\item{upgrade}{When \code{FALSE}, the default, does the minimum amount of work
to give you the latest version of \code{pkg}. It will only upgrade packages if
\code{pkg}, or one of its dependencies, explicitly requires a higher version
than what you currently have.

When \code{upgrade = TRUE}, will do ensure that you have the latest version of
\code{pkg} and all its dependencies.}

\item{ask}{Whether to ask for confirmation when installing a different
version of a package that is already installed. Installations that only
add new packages never require confirmation.}

\item{dependencies}{Dependency types. See
\code{\link[pkgdepends:as_pkg_dependencies]{pkgdepends::as_pkg_dependencies()}} for possible values. Note that
changing this argument from the default might result an installation
failure, e.g. if you set it to \code{FALSE}, packages might not build if
their dependencies are not already installed.}
}
\value{
Data frame, with information about the installed package(s).
}
\description{
Installs a package tree (or source package file), together with its
dependencies.
}
\details{
\code{local_install()} is equivalent to \code{pkg_install("local::.")}.
}
\seealso{
Other local package trees: 
\code{\link{local_deps_explain}()},
\code{\link{local_deps}()},
\code{\link{local_install_deps}()},
\code{\link{local_install_dev_deps}()},
\code{\link{local_package_trees}},
\code{\link{pak}()}
}
\concept{local package trees}
