% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_temporal_functions.R
\name{pbdb_richness}
\alias{pbdb_richness}
\title{Temporal variation in taxon richness}
\usage{
pbdb_richness(
  data,
  rank = c("species", "genus", "family", "order", "class", "phylum"),
  res = 1,
  temporal_extent = c(0, 10),
  colour = "#0000FF30",
  bord = "#0000FF",
  ylab = "Richness",
  do_plot = TRUE
)
}
\arguments{
\item{data}{Data frame from a query to PaleobioDB as returned by
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}}.  Important: it is required to have
information about the taxonomic classification of the occurrences
in the data frame, to do that set the \code{show} parameter to
\code{"class"} or \code{"classext"} (see Examples).}

\item{rank}{The taxon rank to be analyzed. The default value is
\code{"species"}.}

\item{res}{Numeric. Sets the duration of the intervals in the
temporal extent.}

\item{temporal_extent}{Numeric vector to set the temporal extent
(min, max).}

\item{colour}{Colour of the area of the polygon in the plot.}

\item{bord}{Colour of the border of the polygon.}

\item{ylab}{A label for the y axis.}

\item{do_plot}{Logical indicating whether to produce a plot (\code{TRUE}
by default).}
}
\value{
A data frame with the richness aggregated by the taxon
rank in the specified temporal extent and resolution.
}
\description{
Returns a data frame of temporal variation in taxon richness in the
indicated temporal extent and resolution from the provided
occurrence data and optionally produces a plot from it.
}
\examples{
\dontrun{
  data <- pbdb_occurrences(
    limit = "all",
    vocab = "pbdb",
    base_name = "Canidae",
    show = "class"
  )
  pbdb_richness(data, rank = "species", res = 0.2, temporal_extent = c(0, 3))
}
}
