% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfBoxCox.R
\name{pfBoxCox}
\alias{pfBoxCox}
\title{Box-Cox transformation of Charcoal series}
\usage{
pfBoxCox(serie, alpha = 0.01, type = "BoxCox1964")
}
\arguments{
\item{serie}{A vector of charcoal values.}

\item{alpha}{Numeric, the "shift" parameter, default=0.01.}

\item{type}{Character, the Box-Cox transformation formulation, can be either
"BoxCox1964" (default) for the original Box & Cox (1964) formulation, or
"JohnDraper" for the John & Draper (1980) modulus transformation.}
}
\value{
\item{X}{Vector of transformed charcoal values}
}
\description{
Box-Cox transformation of charcoal series, the maximum likelihood estimation
of lambda is derived from the boxcox.R function in the Venables and Ripley
MASS library included in R 2.6.1
}
\examples{

# Select a site
ID=pfSiteSel(site_name=="Pas-de-Fond")

# Extract data
A=pfExtract(ID)

B=pfBoxCox(A[,4],0.1)
plot(B,type="l")


}
\references{
Venables, W. N., Ripley, B. D., & Venables, W. N. (1994). Modern
applied statistics with S-PLUS (Vol. 250). New York: Springer-verlag. \cr
\cr Box, G.E.P. & Cox, D. R.(1964) An analysis of transformations, Journal
of the Royal Statistical Society, Series B, 26, 211-252. \cr \cr John, J. A.
& Draper N. R. (1980) Analternative family of transformations, Applied
Statistics, 29, 190-197.
}
\seealso{
\code{\link{pfTransform}}
}
\author{
P. Bartlein
}
