% Generated by roxygen2 (4.0.1): do not edit by hand
\name{simPaleoTrees}
\alias{simPaleoTrees}
\title{Simulating Un-Conditioned Trees of Fossil Taxa}
\usage{
simPaleoTrees(p, q, r, ntrees = 1, all.extinct = FALSE,
  modern.samp.prob = 1, mintime = 1, maxtime = 100, mintaxa = 2,
  maxtaxa = 500, anag.rate = 0, prop.bifurc = 0, prop.cryptic = 0,
  drop.zlb = TRUE, print.runs = FALSE, ranges.only = TRUE, plot = FALSE)
}
\arguments{
\item{ntrees}{Number of trees to simulate}

\item{all.extinct}{Condition on all taxa being extinct by modern? Default is
false}

\item{modern.samp.prob}{Probability of sampling living taxa at the present
day (time=0), see documentation for sampleRanges}

\item{prop.cryptic}{Proportion of branching events with no morphological
differentiation (i.e. cryptic speciation) relative to branching events
associated with morphological differentiation (budding and/or bifurcating
cladogenesis). Trees with cryptic taxa are always returned with cryptic
taxa unmerged (see sampleRanges).}

\item{drop.zlb}{Should zero-length branches be dropped?}

\item{ranges.only}{If TRUE (the default), the ranges returned in $ranges
are given as taxon first and last occurrences only. If
FALSE, $ranges returns the times of all sampling events for each taxon
as vectors within a list.}

\item{plot}{Should data be plotted as it is simulated?}

\item{p}{Instantaneous rate of origination/branching per lineage-time units.}

\item{q}{Instantaneous rate of extinction per lineage-time units.}

\item{mintime}{Minimum time units to run any given simulation before
stopping.}

\item{maxtime}{Maximum time units to run any given simulation before
stopping.}

\item{mintaxa}{Minimum number of total taxa over the entire history of a
clade necessary for a dataset to be accepted.}

\item{maxtaxa}{Maximum number of total taxa over the entire history of a
clade necessary for a dataset to be accepted.}

\item{anag.rate}{Instantaneous rate of anagenesis (i.e. pseudospeciation/pseudoextinction).}

\item{prop.bifurc}{Proportion of morphological branching by bifurcating
cladogenesis relative to budding cladogenesis.}

\item{print.runs}{If TRUE, prints the proportion of simulations accepted for
output to the terminal.}

\item{r}{Instantaneous rate of sampling per lineage-time units.}
}
\value{
Output is an object of class multiphylo containing the simulated
phylogenies, unless ntrees is one in which case the output is a phylogeny of
class 'phylo'.

Additionally, each of these simulated phylogenies will have the original
simulated taxa data (from simFossilTaxa) and sampled ranges (from
sampleRanges) attached as the elements $taxa and $ranges to each phylo
object.
}
\description{
Creates sets of paleo-trees with minimal conditioning and with sampling such
that lineages may be missing and terminal branches are truncated, but
node-times are known perfectly
}
\details{
This function is essentially a complex wrapper for simFossilTaxa, sampleRanges
and taxa2phylo, and users should refer to the respective documentation for those
functions in addition to this manual page: \code{\link{simFossilTaxa}},
\code{\link{taxa2phylo}} and \code{\link{sampleRanges}}.

This function will output simulated phylogenies of fossil taxa
where the divergence times are perfectly known, only sampled taxa are
included on the tree and tips are located at the last observed time for the
species (the apparent time of extinction, except for living taxa).

simPaleoTrees essentially uses simFossilTaxa with no.cond as TRUE and other
minimal conditioning, so as to get as unbiased a sample of simulations as
possible (without exceeding the maximum constraints). This is useful for
birth-death analyses, although a number of options available in
simFossilTaxa are thus unavailable in simPaleoTrees. By default, there is no
conditioning on the number of extant taxa, living taxa are sampled perfectly
at time 0 and zero-length branches are dropped. Unlike simFossilTaxa, you
cannot condition on a certain number of extant taxa, only whether they are
allowed or not (via all.extinct). As of version 1.6, there are now options
relating to speciation modes. By default, taxa are only simulated under
budding cladogenesis but this can be changed with the arguments anag.rate,
prop.bifurc and prop.cryptic. Trees with cryptic taxa are always returned
with cryptic taxa unmerged (see sampleRanges).

Because the divergence times are known perfectly, yet tips are at the
apparent time of extinction and unsampled taxa are dropped, one should not
use the output of this analysis except for very specialized simulation
analyses. The results are probably not anything like real datasets of
paleontological phylogenies, at least in most aspects.

The print.runs argument does not work precisely as in simFossilTaxa; it only
counts how many accepted datasets from simFossilTaxa are acceptable for
output after the simulation of sampling.
}
\examples{
set.seed(444)
#simulate trees conditioned to have no living descendants
trees <- simPaleoTrees(p=0.1,q=0.1,r=0.5,ntrees=10,all.extinct=TRUE,maxtime=100,
    print.runs=TRUE,plot=TRUE)
#number of tips
sapply(trees,Ntip)

#simulate trees conditioned to have possible living taxa and perfect sampling at modern
trees <- simPaleoTrees(p=0.1,q=0.1,r=0.5,ntrees=10,all.extinct=FALSE,maxtime=100,
    modern.samp.prob=TRUE,print.runs=TRUE,plot=TRUE)
#number of tips
sapply(trees,Ntip)
}
\seealso{
\code{\link{simFossilTaxa}}, \code{\link{taxa2phylo}},
\code{\link{sampleRanges}}
}

