% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoaxis.R
\name{autoaxis}
\alias{autoaxis}
\title{Auto Axis Tool}
\usage{
autoaxis(
  side,
  major = NA,
  major_grid = FALSE,
  minor = NA,
  minor_grid = FALSE,
  format = "\%Y-\%m-\%d",
  spacing = TRUE,
  tck = -0.03,
  ...
)
}
\arguments{
\item{side}{Side to add axis, 1 = bottom, 2 = left, 3 = top, 4 = right}

\item{major}{Spacing of major axis ticks and labels (or approx. number of
intervals if \code{spacing = FALSE}). If the axis is date or time,
use a interval specified in \code{?seq.POSIXt}, such as 'sec' or
'week'}

\item{major_grid}{Add grid lines corresponding to major axis ticks, \code{TRUE}
to get default translucent black, otherwise colour (name or hex)}

\item{minor}{Spacing (or number) of minor ticks (note, no label for minor).
If given as a character string, it will pass to \code{seq.POSIXt}}

\item{minor_grid}{Add gridlines for minor ticks, \code{TRUE} uses transparent
black, otherwise colour string}

\item{format}{Date or time format for major axis -- \code{major} must be a
character string in this case}

\item{spacing}{Should \code{major} and \code{minor} be interpreted as tick spacing
(default) or approximate number of ticks}

\item{tck}{Size of axis tick: minor axis will always take half this value}

\item{...}{Additional arguemnts passed to \code{axis()}, for example \code{las=2}
for perpendicular labels}
}
\value{
No return value (\code{NULL})
}
\description{
Overlay base plot axis with custom intervals
}
\details{
Major and minor tick marks can be specified in a number of ways:
\itemize{
\item As a character string if the axis is datetime, such as 'year' or 'hour'
which are passed to \code{seq()}. These can be prefixed with an integer multiplier,
for example '6 hour', '30-sec',  or '10year'. Any non-alphanumeric separator
can be used, or none.
\item As a tick interval using the default \code{spacing = TRUE}
\item As an approximate number of tick marks to include, using \code{pretty()} to find
the best interval, using \code{spacing = FALSE}
}

Major adds labels and ticks, minor is just half-sized ticks marks. Both
tick sizes can be changed (or direction changed) using \code{tck}.

Three different datetime axis are possible: year, day-offset, seconds-offset. Use
\code{format} to specify how the label should appear, such as '\%b \%Y' (see \code{?strptime})
\itemize{
\item Year should be treated as a conventional numeric axis, use \code{major=1/12} not \code{major='month'}
\item day-offset is an axis of \code{class(x)=='Date'} and is identified if the axis range exists
within +/-9e4, meaning within dates 1723 - 2216
\item second-offset is an axis of \code{class(x)=='POSIXct'} and is identified by a range outside
of +/-9e4. This will give very strange results if your entire POSIXct axis is within
24 hours of 1970-01-01
}

A grid can be added at the same time by setting \code{major_grid} or \code{minor_grid} to \code{TRUE}
or a colour string. If \code{TRUE}, a transparent black is used by default.

Any other options can be passed through to \code{axis()} directly (see \code{?axis}), most
notably \code{las = 2} to rotate the labels, and \code{cex.axis} for label size.

This does NOT work well for \code{barplot()} categorical axis, for this continue to use
the basic \code{axis()} function with custom labels, see examples.
}
\examples{
plot(sunspots) # This time series is actually given in decimal years
  autoaxis(side=3, major=50, major_grid='coral', minor=10, minor_grid=TRUE, spacing=TRUE)
  autoaxis(side=4, major=11, minor=25, spacing=FALSE, las=2, cex.axis=0.5, tck=0.02)

plot(seq(as.POSIXct('2020-01-01'),as.POSIXct('2020-01-03'),length.out=1e3),
    rnorm(1e3), xlab='POSIXct', xaxt='n')
  autoaxis(side=1, major='day', minor='hour', format='\%A')
  autoaxis(side=3, major='6 hour', format='\%H:\%M')

plot(seq(as.Date('2013-02-01'),as.Date('2020-01-03'),length.out=1e3),
    rnorm(1e3), xlab='Date', xaxt='n')
  autoaxis(side=1, major='year', minor='quarter', format='\%Y')
  autoaxis(side=3, minor='3month', minor_grid=TRUE)

# For barplot() use base functions - remember to set width=1, space=0
# otherwise bars will not be plotted on integer x-coordinates
barplot(mtcars$mpg, width=1, space=0, ylab='mpg')
  # Adjust the x-axis down by 0.5 so that the tick is in centre of each bar
  axis(side=1, at=-0.5+1:length(mtcars$mpg), labels=rownames(mtcars), las=2 )
  # Often prettier, label each bar inside the bar itself using text()
  text(x=-1+1:length(mtcars$mpg), y=1, pos=4,
    labels=rownames(mtcars), srt=90, cex=0.7)
  # autoaxis can still be used for adjusting the numeric scale
  autoaxis(side=2, major=5, major_grid=TRUE, minor=1, minor_grid=TRUE)

}
