% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotLengths.R
\name{PlotLengths}
\alias{PlotLengths}
\title{A wrapper for PlotDistro() for "pp_length", "v1_length", "v2_length".}
\usage{
PlotLengths(pp, pp.bg, set.ylab = "palmDB density")
}
\arguments{
\item{pp}{A palmprint.df row to use for the plot "value"}

\item{pp.bg}{A multiple palmprint.df  for the plot background "distribution"}

\item{set.ylab}{Label for y-axis ["palmDB density"]}
}
\value{
A grid-table object of "pp_length", "v1_length", "v2_length"
}
\description{
A wrapper for PlotDistro() for "pp_length", "v1_length", "v2_length".
}
\examples{
data("waxsys.palmprint")
data("palmdb")

ppLen <- PlotLengths(pp = waxsys.palmprint, pp.bg = palmdb)
plot(ppLen)

}
\keyword{fev}
\keyword{palmid}
