% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mif2.R, R/mif2_methods.R
\docType{class}
\name{mif2}
\alias{mif2}
\alias{mif2d.ppomp-class}
\alias{mif2,panelPomp-method}
\alias{mif2,mif2d.ppomp-method}
\alias{traces,mif2d.ppomp-method}
\title{PIF: Panel iterated filtering}
\usage{
\S4method{mif2}{panelPomp}(
  data,
  Nmif = 1,
  shared.start,
  specific.start,
  start,
  Np,
  rw.sd,
  cooling.type = c("geometric", "hyperbolic"),
  cooling.fraction.50,
  block = FALSE,
  verbose = getOption("verbose"),
  ...
)

\S4method{mif2}{mif2d.ppomp}(
  data,
  Nmif,
  shared.start,
  specific.start,
  start,
  Np,
  rw.sd,
  cooling.type,
  cooling.fraction.50,
  block,
  ...
)

\S4method{traces}{mif2d.ppomp}(object, pars, ...)
}
\arguments{
\item{data}{An object of class \code{panelPomp} or inheriting class.}

\item{Nmif}{The number of filtering iterations to perform.}

\item{shared.start}{named numerical vector; the starting guess of the shared parameters.}

\item{specific.start}{matrix with row parameter names and column unit names;
the starting guess of the specific parameters.}

\item{start}{A named numeric vector of parameters at which to start the IF2 procedure.}

\item{Np}{the number of particles to use.
This may be specified as a single positive integer, in which case the same number of particles will be used at each timestep.
Alternatively, if one wishes the number of particles to vary across timesteps, one may specify \code{Np} either as a vector of positive integers of length \preformatted{length(time(object,t0=TRUE))} or as a function taking a positive integer argument.
In the latter case, \code{Np(k)} must be a single positive integer, representing the number of particles to be used at the \code{k}-th timestep:
\code{Np(0)} is the number of particles to use going from \code{timezero(object)} to \code{time(object)[1]},
\code{Np(1)}, from \code{timezero(object)} to \code{time(object)[1]},
and so on,
while when \code{T=length(time(object))}, \code{Np(T)} is the number of particles to sample at the end of the time-series.}

\item{rw.sd}{An unevaluated expression of the form \code{quote(rw.sd())} to
be used for all panel units. If a \code{list} of such expressions of the
same length as the \code{object} argument is provided, each list element
will be used for the corresponding panel unit.}

\item{cooling.type, cooling.fraction.50}{specifications for the cooling schedule,
i.e., the manner and rate with which the intensity of the parameter perturbations is reduced with successive filtering iterations.
\code{cooling.type} specifies the nature of the cooling schedule.
See below (under \dQuote{Specifying the perturbations}) for more detail.}

\item{block}{A logical variable determining whether to carry out block
resampling of unit-specific parameters.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}

\item{...}{....}

\item{object}{an object resulting from the application of IF2 (i.e., of
class \code{mif2d.ppomp})}

\item{pars}{names of parameters}
}
\value{
\code{mif2()} returns an object of class \code{mif2d.ppomp}.

\code{traces()} returns a \code{matrix} with estimated parameter values at
different iterations of the IF2 algorithm in the natural scale. The default
is to return values for all parameters but a subset of parameters can be
passed via the optional argument \code{pars}.
}
\description{
Tools for applying iterated filtering algorithms to panel data.
The panel iterated filtering of \Breto et al. (2020) extends to
panel models the improved iterated filtering algorithm (Ionides et al.,
2015) for estimating parameters of a partially observed Markov process.
Iterated filtering algorithms rely on extending a partially observed Markov
process model of interest by introducing random perturbations to the model
parameters. The space where the original parameters live is then explored
at each iteration by running a particle filter. Convergence to a maximum
likelihood estimate has been established for appropriately constructed
procedures that iterate this search over the parameter space while
diminishing the intensity of perturbations (Ionides et al. 2006, 2011, 2015).
}
\examples{
## start with a panelPomp object
p <- panelRandomWalk()
## specify which parameters to estimate via rw_sd() and how fast to cool
mp <- mif2(p,Np=10,rw.sd=rw_sd(X.0=0.2),cooling.fraction.50=0.5,cooling.type="geometric")
mp
## the object resulting from an initial estimation can be used as a new starting point
mmp <- mif2(mp,Np=10,rw.sd=rw_sd(X.0=0.2),cooling.fraction.50=0.5,cooling.type="geometric")
mmp
## convergence can be partly diagnosed by checking estimates and likelihoods at different iterations
traces(mmp)
}
\references{
\breto2020

\ionides2006

\ionides2011

\ionides2015

\king2016
}
\seealso{
\pkg{pomp}'s mif2 at \link[pomp]{mif2},
\link{panel_loglik}

Other panelPomp workhorse functions: 
\code{\link{panelPomp}},
\code{\link{panel_loglik}},
\code{\link{pfilter}()}
}
\author{
Carles \Breto
}
\concept{panelPomp workhorse functions}
