% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panelGompertzLikelihood.R
\name{panelGompertzLikelihood}
\alias{panelGompertzLikelihood}
\title{Likelihood for a panel Gompertz model via a Kalman filter}
\usage{
panelGompertzLikelihood(x, panelPompObject, params)
}
\arguments{
\item{x}{named vector for a subset of parameters, corresponding to
those being estimated.}

\item{panelPompObject}{a panel Gompertz model.}

\item{params}{named vector containing all the parameters of the panel Gompertz model. Estimated parameters are overwritten by x.}
}
\value{
A \code{numeric} value.
}
\description{
Evaluates the likelihood function for a panel Gompertz model,
using a format convenient for maximization by optim() to obtain a maximum
likelihood estimate. Specifically, estimated and fixed parameters are
supplied by two different arguments.
}
\examples{
pg <- panelGompertz(N=2,U=2)
panelGompertzLikelihood(coef(pg),pg,coef(pg))
}
\author{
Edward L. Ionides
}
