% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asym.R, R/diffs.R
\name{tidy.asym}
\alias{tidy.asym}
\alias{tidy.fdm}
\alias{glance.fdm}
\title{Tidy methods for \code{fdm} and \code{asym} models}
\usage{
\method{tidy}{asym}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{fdm}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{glance}{fdm}(x, ...)
}
\arguments{
\item{x}{An \code{fdm} or \code{asym} object.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1. Defaults
to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Ignored}
}
\description{
\code{panelr} provides methods to access \code{fdm} and \code{asym} data in a
tidy format
}
\examples{

data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
model <- fdm(lwage ~ wks + union, data = wages)
if (requireNamespace("generics")) {
  generics::tidy(model)
}

}
