% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{bootstrap_irf}
\alias{bootstrap_irf}
\alias{bootstrap_irf.pvargmm}
\title{Empirical estimation of PVAR Impulse Response Confidence Bands}
\usage{
bootstrap_irf(model, typeof_irf, n.ahead, nof_Nstar_draws, confidence.band)

\method{bootstrap_irf}{pvargmm}(model, typeof_irf = c("OIRF", "GIRF"),
  n.ahead, nof_Nstar_draws, confidence.band = 0.95)
}
\arguments{
\item{model}{A PVAR model}

\item{typeof_irf}{\code{"OIRF"} or \code{GIRF}}

\item{n.ahead}{n ahead steps}

\item{nof_Nstar_draws}{Number of draws}

\item{confidence.band}{Confidence band}
}
\description{
Uses blockwise sampling of individuals (bootstrapping)
}
\examples{
\dontrun{
data("ex1_dahlbergdata")
bootstrap_irf(ex1_dahlberg_data, 
              typeof_irf = "OIRF", 
              n.ahead = 12, 
              nof_Nstar_draws = 2, 
              confidence.band = 0.95)
}
}
