% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Options.R
\name{Options}
\alias{Options}
\title{Class for Package Options}
\description{
This class holds public fields that represent the package
\code{\link[base:options]{options}} used to configure the default behavior of the
functionality \code{\link{parabar}} provides.
}
\details{
An instance of this class is automatically created and stored in the session
\code{\link[base:options]{base::.Options}} at load time. This instance can be accessed and changed
via \code{\link[base:options]{getOption("parabar")}}. Specific package
\code{\link[base:options]{options}} can be retrieved using the helper function
\code{\link[=get_option]{get_option()}}.
}
\examples{
# Set the default package options (i.e., automatically set at load time).
set_default_options()

# First, get the options instance from the session options.
parabar <- getOption("parabar")

# Then, disable progress tracking.
parabar$progress_track <- FALSE

# Check that the change was applied (i.e., `progress_track: FALSE`).
getOption("parabar")

# To restore defaults, set the default options again.
set_default_options()

# Check that the change was applied (i.e., `progress_track: TRUE`).
getOption("parabar")

# We can also use the built-in helpers to get and set options more conveniently.

# Get the progress tracking option.
get_option("progress_track")

# Set the progress tracking option to `FALSE`.
set_option("progress_track", FALSE)

# Check that the change was applied (i.e., `progress_track: FALSE`).
get_option("progress_track")

# Get a temporary file for logging the progress.
get_option("progress_log_path")

# Fix the logging file path.
set_option("progress_log_path", "./progress.log")

# Check that the logging path change was applied.
get_option("progress_log_path")

# Restore the logging path to the default behavior.
set_option("progress_log_path", NULL)

# Check that the logging path change was applied.
get_option("progress_log_path")

# Restore the defaults.
set_default_options()

}
\seealso{
\code{\link[=get_option]{get_option()}}, \code{\link[=set_option]{set_option()}}, and
\code{\link[=set_default_options]{set_default_options()}}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{progress_track}}{A logical value indicating whether progress
tracking should be enabled (i.e., \code{TRUE}) or disabled  (i.e.,
\code{FALSE}) globally for compatible backends. The default value is
\code{TRUE}.}

\item{\code{progress_timeout}}{A numeric value indicating the timeout (i.e.,
in seconds) between subsequent checks of the log file for new progress
records. The default value is \code{0.001}.}

\item{\code{progress_wait}}{A numeric value indicating the approximate
duration (i.e., in seconds) to wait between progress bar updates
before checking if the task has finished (i.e., possibly with an
error). The default value is \code{0.1}.}

\item{\code{progress_bar_type}}{A character string indicating the default
bar type to use with compatible backends. Possible values are
\code{"modern"} (the default) or \code{"basic"}.}

\item{\code{progress_bar_config}}{A list of lists containing the default bar
configuration for each supported bar engine. Elements of these lists
represent arguments for the corresponding bar engines. Currently, the
supported bar engines are:
\itemize{
\item \code{modern}: The \code{\link[progress:progress_bar]{progress::progress_bar}} engine, with the following
default configuration:
\itemize{
\item \code{show_after = 0}
\item \code{format = "> completed :current out of :total tasks [:percent] [:elapsed]"}
}
\item \code{basic}: The \code{\link[utils:txtProgressBar]{utils::txtProgressBar}} engine, with no default
configuration.
}}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{progress_log_path}}{A character string indicating the path to
the log file where to track the execution progress of a running task.
The default value is a temporary file generated by
\code{\link[base:tempfile]{base::tempfile()}}. Calling this active binding repeatedly will
yield different temporary file paths. Fixing the path to a specific
value is possible by setting this active binding to a character
string representing the desired path. Setting this active binding to
\code{NULL} will reset it to the default value (i.e., yielding different
temporary file paths).}
}
\if{html}{\out{</div>}}
}
