% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters_simulate.R
\name{parameters_simulate}
\alias{parameters_simulate}
\alias{parameters_simulate.default}
\title{Parameters simulation}
\usage{
parameters_simulate(model, ...)

\method{parameters_simulate}{default}(model, iterations = 1000,
  centrality = "median", ci = 0.95, ci_method = "quantile",
  test = "p-value", ...)
}
\arguments{
\item{model}{Statistical model (no Bayesian models).}

\item{...}{Arguments passed to or from other methods.}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{centrality}{The point-estimates (centrality indices) to compute.  Character (vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{ci}{Value or vector of probability of the CI (between 0 and 1)
to be estimated. Default to \code{.89} (89\%) for Bayesian models and \code{.95} (95\%) for frequentist models.}

\item{ci_method}{The type of index used for Credible Interval. Can be
\code{"HDI"} (default, see \code{\link[bayestestR:hdi]{hdi}}) or \code{"ETI"}
(see \code{\link[bayestestR:eti]{eti}}).}

\item{test}{The indices of effect existence to compute. Character (vector) or
list with one or more of these options: \code{"p_direction"} (or \code{"pd"}),
\code{"rope"}, \code{"p_map"}, \code{"equivalence_test"} (or \code{"equitest"}),
\code{"bayesfactor"} (or \code{"bf"}) or \code{"all"} to compute all tests.
For each "test", the corresponding \pkg{bayestestR} function is called
(e.g. \code{\link[bayestestR:rope]{rope}} or \code{\link[bayestestR:p_direction]{p_direction}}) and its results
included in the summary output.}
}
\value{
A data frame with simulated parameters.
}
\description{
Compute simulated draws of parameters and their related indices such as Confidence Intervals (CI) and p-values. Simulating parameter draws can be seen as a (computationally faster) alternative to bootstrapping.
}
\details{
\subsection{Technical Details}{
    \code{model_simulate()} is a computationally faster alternative
    to \code{model_bootstrap()}. Simulated draws for coefficients are based
    on a multivariate normal distribution (\code{MASS::mvrnorm()}) with mean
    \code{mu = coef(model)} and variance \code{Sigma = vcov(model)}.
  }
  \subsection{Models with Zero-Inflation Component}{
    For models from packages \pkg{glmmTMB}, \pkg{pscl}, \pkg{GLMMadaptive} and
    \pkg{countreg}, the \code{component} argument can be used to specify
    which parameters should be simulated. For all other models, parameters
    from the conditional component (fixed effects) are simulated. This may
    include smooth terms, but not random effects.
  }
}
\examples{
library(parameters)
library(glmmTMB)

model <- lm(Sepal.Length ~ Species * Petal.Width + Petal.Length, data = iris)
parameters_simulate(model)

model <- glmmTMB(
  count ~ spp + mined + (1 | site),
  ziformula = ~mined,
  family = poisson(),
  data = Salamanders
)
parameters_simulate(model, centrality = "mean")
parameters_simulate(model, ci = c(.8, .95), component = "zero_inflated")
}
\references{
Gelman A, Hill J. Data analysis using regression and multilevel/hierarchical models. Cambridge; New York: Cambridge University Press 2007: 140-143
}
\seealso{
\code{\link{model_bootstrap}}, \code{\link{parameters_bootstrap}}, \code{\link{model_simulate}}
}
