% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_estimation.R, R/standard_error.R
\name{standard_error_robust}
\alias{standard_error_robust}
\alias{standard_error}
\alias{standard_error.factor}
\alias{standard_error.default}
\alias{standard_error.merMod}
\alias{standard_error.glmmTMB}
\alias{standard_error.MixMod}
\alias{standard_error.mixor}
\alias{standard_error.clm2}
\title{Extract standard errors}
\usage{
standard_error_robust(
  model,
  vcov_estimation = "HC",
  vcov_type = c("HC3", "const", "HC", "HC0", "HC1", "HC2", "HC4", "HC4m", "HC5", "CR0",
    "CR1", "CR1p", "CR1S", "CR2", "CR3"),
  vcov_args = NULL,
  ...
)

standard_error(model, ...)

\method{standard_error}{factor}(model, force = FALSE, verbose = TRUE, ...)

\method{standard_error}{default}(model, method = NULL, ...)

\method{standard_error}{merMod}(model, effects = c("fixed", "random"), method = NULL, ...)

\method{standard_error}{glmmTMB}(
  model,
  effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated"),
  ...
)

\method{standard_error}{MixMod}(
  model,
  effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated"),
  ...
)

\method{standard_error}{mixor}(model, effects = c("all", "fixed", "random"), ...)

\method{standard_error}{clm2}(model, component = c("all", "conditional", "scale"), ...)
}
\arguments{
\item{model}{A model.}

\item{vcov_estimation}{String, indicating the suffix of the \code{vcov*()}-function
from the \pkg{sandwich}-package, e.g. \code{vcov_estimation = "CL"} (which
calls \code{\link[sandwich]{vcovCL}} to compute clustered covariance matrix
estimators), or \code{vcov_estimation = "HC"} (which calls
\code{\link[sandwich]{vcovHC}} to compute heteroskedasticity-consistent
covariance matrix estimators).}

\item{vcov_type}{Character vector, specifying the estimation type for the
robust covariance matrix estimation (see \code{\link[sandwich]{vcovHC}} for
details).}

\item{vcov_args}{List of named vectors, used as additional arguments that
are passed down to the \pkg{sandwich}-function specified in \code{vcov_estimation}.}

\item{...}{Arguments passed to or from other methods. For \code{standard_error()},
if \code{method = "robust"}, arguments \code{vcov_estimation}, \code{vcov_type}
and \code{vcov_args} can be passed down to \code{standard_error_robust()}.}

\item{force}{Logical, if \code{TRUE}, factors are converted to numerical
values to calculate the standard error, with the lowest level being the
value \code{1} (unless the factor has numeric levels, which are converted
to the corresponding numeric value). By default, \code{NA} is returned
for factors or character vectors.}

\item{verbose}{Toggle off warnings.}

\item{method}{If \code{"robust"}, robust standard errors are computed
by calling \code{\link[=standard_error_robust]{standard_error_robust()}}.
\code{standard_error_robust()}, in turn, calls one of the \code{vcov*()}-functions
from the \pkg{sandwich}-package for robust covariance matrix estimators.}

\item{effects}{Should standard errors for fixed effects or random effects
be returned? Only applies to mixed models. May be abbreviated. When
standard errors for random effects are requested, for each grouping factor
a list of standard errors (per group level) for random intercepts and slopes
is returned.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}
}
\value{
A data frame.
}
\description{
\code{standard_error()} attempts to return standard errors of model parameters, while \code{standard_error_robust()} attempts to return robust standard errors.
}
\note{
\code{standard_error_robust()} resp. \code{standard_error(method = "robust")}
  rely on the \pkg{sandwich}-package and will thus only work for those models
  supported by that package.
}
\examples{
model <- lm(Petal.Length ~ Sepal.Length * Species, data = iris)
standard_error(model)

# robust standard errors, calling sandwich::vcovHC(type="HC3") by default
standard_error_robust(model)

# cluster-robust standard errors, using clubSandwich
iris$cluster <- factor(rep(LETTERS[1:8], length.out = nrow(iris)))
standard_error_robust(
  model,
  vcov_type = "CR2",
  vcov_args = list(cluster = iris$cluster)
)
}
