% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_heterogeneity.R
\name{parametric_heterogeneity}
\alias{parametric_heterogeneity}
\title{Test coefficient and residual heterogeneity across models.}
\usage{
parametric_heterogeneity(model_list)
}
\arguments{
\item{model_list}{A list of regression models.}
}
\value{
Data frame containing name of items tested for heterogeneity,
 F-statistics for homogeneity tests, numerator degrees of freedom,
 denominator degrees of freedom, and the associated p-value.
}
\description{
An umbrella function to assess heterogeneity across functions.
}
\details{
\code{parametric_heterogeneity} is used to run and format results from
\code{\link{coefficient_manova}}, \code{\link{coefficient_anova}}, and
\code{\link{residual_levene}}, the last for \code{lm} models only. Please see
those functions for more detail.
}
\examples{
 states = as.data.frame(state.x77)

 m1 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='Northeast')
 m2 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='South')
 m3 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='North Central')
 m4 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='West')

 mList = list(m1, m2, m3, m4)

 parametric_heterogeneity(model_list = mList)

}
\seealso{
\itemize{
   \item \code{\link{coefficient_manova}}
   \item \code{\link{coefficient_anova}}
   \item \code{\link{residual_levene}}
 }
}
