% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_base.R
\encoding{UTF-8}
\name{load_base}
\alias{load_base}
\title{Helper function for loading RPDR data into R.}
\usage{
load_base(
  file,
  merge_id = "EMPI",
  sep = ":",
  id_length = "standard",
  perc = 0.6,
  na = TRUE,
  identical = TRUE,
  nThread = 4,
  mrn_type = FALSE,
  src = "mrn"
)
}
\arguments{
\item{file}{string, full file path to given RPDR txt.}

\item{merge_id}{string, column name to use to create \emph{ID_MERGE} column used to merge different datasets. Defaults to \emph{EMPI},
as it is the preferred MRN in the RPDR system. In case of mrn dataset, leave at EMPI, as it is automatically converted to: "Enterprise_Master_Patient_Index".}

\item{sep}{string, divider between hospital ID and MRN. Defaults to \emph{:}.}

\item{id_length}{string, indicating whether to modify MRN length based-on required values \emph{id_length = standard}, or to keep lengths as is \emph{id_length = asis}.
If \emph{id_length = standard} then in case of \emph{MGH, BWH, MCL, EMPI and PMRN} the length of the MRNs are corrected accordingly by adding zeros, or removing numeral from the beginning.
In other cases the lengths are unchanged. Defaults to \emph{standard}.}

\item{perc}{numeric, a number between 0-1 indicating which parsed ID columns to keep. Data present in \emph{perc x 100\%} of patients are kept.}

\item{na}{boolean, whether to remove columns with only NA values. Defaults to \emph{TRUE}.}

\item{identical}{boolean, whether to remove columns with identical values. Defaults to \emph{TRUE}.}

\item{nThread}{integer, number of threads to use by data.table for reading data and parsing ID data.}

\item{mrn_type}{boolean, should data in \emph{MRN_Type} and \emph{MRN} be parsed. Defaults to \emph{FALSE}, as it is not advised to parse these for all data sources as it takes considerable time.}

\item{src}{string, what is the three letter source ID of the file, such as  \emph{dem}.}
}
\value{
data table, with minimally parsed data and the raw data.
\describe{
 \item{ID_MERGE}{numeric, defined IDs by \emph{merge_id}, used for merging later.}
 \item{ID_src_EMPI}{string, EMPI IDs from \emph{src} datasource, if the datasource is not mrn. Data is formatted using pretty_mrn().}
 \item{ID_src_PMRN}{string, PMRN IDs from \emph{src} datasource, if the datasource is not mrn. Data is formatted using pretty_mrn().}
 \item{ID_scr_loc}{string, from datasource \emph{src}, if mrn_type == TRUE, then the data in \emph{MRN_Type} and \emph{MRN} are parsed into IDs corresponding to locations \emph{(loc)}. Data is formatted using pretty_mrn().}
 }
}
\description{
Helper function to load different datasources from RPDR. Should not be used on its own.
}
\keyword{internal}
