% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg_brulee.R
\name{details_logistic_reg_brulee}
\alias{details_logistic_reg_brulee}
\title{Logistic regression via brulee}
\description{
\code{\link[brulee:brulee_logistic_reg]{brulee::brulee_logistic_reg()}} fits a generalized linear model for binary
outcomes. A linear combination of the predictors is used to model the log
odds of an event.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 2 tuning parameter:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: 0.001)
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: 0.0)
}

The use of the L1 penalty (a.k.a. the lasso penalty) does \emph{not} force
parameters to be strictly zero (as it does in packages such as glmnet).
The zeroing out of parameters is a specific feature the optimization
method used in those packages.

Other engine arguments of interest:
\itemize{
\item \code{optimizer()}: The optimization method. See
\code{\link[brulee:brulee_linear_reg]{brulee::brulee_linear_reg()}}.
\item \code{epochs()}: An integer for the number of passes through the training
set.
\item \code{lean_rate()}: A number used to accelerate the gradient decsent
process.
\item \code{momentum()}: A number used to use historical gradient information
during optimization (\code{optimizer = "SGD"} only).
\item \code{batch_size()}: An integer for the number of training set points in
each batch.
\item \code{stop_iter()}: A non-negative integer for how many iterations with
no improvement before stopping. (default: 5L).
\item \code{class_weights()}: Numeric class weights. See
\code{\link[brulee:brulee_logistic_reg]{brulee::brulee_logistic_reg()}}.
}
}

\subsection{Translation from parsnip to the original package (classification)}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{logistic_reg(penalty = double(1)) \%>\% 
  set_engine("brulee") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Logistic Regression Model Specification (classification)
## 
## Main Arguments:
##   penalty = double(1)
## 
## Computational engine: brulee 
## 
## Model fit template:
## brulee::brulee_logistic_reg(x = missing_arg(), y = missing_arg(), 
##     penalty = double(1))
}

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip
will convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
