% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg_glmer.R
\name{details_logistic_reg_glmer}
\alias{details_logistic_reg_glmer}
\title{Logistic regression via mixed models}
\description{
The \code{"glmer"} engine estimates fixed and random effect regression parameters
using maximum likelihood (or restricted maximum likelihood) estimation.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has no tuning parameters.
}

\subsection{Translation from parsnip to the original package}{

The \strong{multilevelmod} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(multilevelmod)

logistic_reg() \%>\% 
  set_engine("glmer") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Logistic Regression Model Specification (classification)
## 
## Computational engine: glmer 
## 
## Model fit template:
## lme4::glmer(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     family = binomial)
}\if{html}{\out{</div>}}
}

\subsection{Predicting new samples}{

This model can use subject-specific coefficient estimates to make
predictions (i.e. partial pooling). For example, this equation shows the
linear predictor (\emph{η}) for a random intercept:

\emph{η}\if{html}{\out{<sub>}}\emph{i}\if{html}{\out{</sub>}} = (\emph{β}\if{html}{\out{<sub>}}0\if{html}{\out{</sub>}}+\emph{b}\if{html}{\out{<sub>}}0\emph{i}\if{html}{\out{</sub>}}) + \emph{β}\if{html}{\out{<sub>}}1\if{html}{\out{</sub>}}\emph{x}\if{html}{\out{<sub>}}\emph{i}1\if{html}{\out{</sub>}}

where \emph{i} denotes the \code{i}th independent experimental unit
(e.g. subject). When the model has seen subject \code{i}, it can use that
subject’s data to adjust the \emph{population} intercept to be more specific
to that subjects results.

What happens when data are being predicted for a subject that was not
used in the model fit? In that case, this package uses \emph{only} the
population parameter estimates for prediction:

\emph{η̂}\if{html}{\out{<sub>}}\emph{i}′\if{html}{\out{</sub>}} = \emph{β̂}\if{html}{\out{<sub>}}0\if{html}{\out{</sub>}} + \emph{β̂**x}\if{html}{\out{<sub>}}\emph{i}′1\if{html}{\out{</sub>}}

Depending on what covariates are in the model, this might have the
effect of making the same prediction for all new samples. The population
parameters are the “best estimate” for a subject that was not included
in the model fit.

The tidymodels framework deliberately constrains predictions for new
data to not use the training set or other data (to prevent information
leakage).
}

\subsection{Preprocessing requirements}{

There are no specific preprocessing needs. However, it is helpful to
keep the clustering/subject identifier column as factor or character
(instead of making them into dummy variables). See the examples in the
next section.
}

\subsection{Other details}{

The model can accept case weights.

With parsnip, we suggest using the formula method when fitting:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)
data("toenail", package = "HSAUR3")

logistic_reg() \%>\% 
  set_engine("glmer") \%>\% 
  fit(outcome ~ treatment * visit + (1 | patientID), data = toenail)
}\if{html}{\out{</div>}}

When using tidymodels infrastructure, it may be better to use a
workflow. In this case, you can add the appropriate columns using
\code{add_variables()} then supply the typical formula when adding the model:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)

glmer_spec <- 
  logistic_reg() \%>\% 
  set_engine("glmer")

glmer_wflow <- 
  workflow() \%>\% 
  # The data are included as-is using:
  add_variables(outcomes = outcome, predictors = c(treatment, visit, patientID)) \%>\% 
  add_model(glmer_spec, formula = outcome ~ treatment * visit + (1 | patientID))

fit(glmer_wflow, data = toenail)
}\if{html}{\out{</div>}}
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{References}{
\itemize{
\item J Pinheiro, and D Bates. 2000. \emph{Mixed-effects models in S and
S-PLUS}. Springer, New York, NY
\item West, K, Band Welch, and A Galecki. 2014. \emph{Linear Mixed Models: A
Practical Guide Using Statistical Software}. CRC Press.
\item Thorson, J, Minto, C. 2015, Mixed effects: a unifying framework for
statistical modelling in fisheries biology. \emph{ICES Journal of Marine
Science}, Volume 72, Issue 5, Pages 1245–1256.
\item Harrison, XA, Donaldson, L, Correa-Cano, ME, Evans, J, Fisher, DN,
Goodwin, CED, Robinson, BS, Hodgson, DJ, Inger, R. 2018. \emph{A brief
introduction to mixed effects modelling and multi-model inference in
ecology}. PeerJ 6:e4794.
\item DeBruine LM, Barr DJ. Understanding Mixed-Effects Models Through
Data Simulation. 2021. \emph{Advances in Methods and Practices in
Psychological Science}.
}
}
}
\keyword{internal}
