% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_tree_rpart.R
\name{details_bag_tree_rpart}
\alias{details_bag_tree_rpart}
\title{Bagged trees via rpart}
\description{
\code{\link[baguette:bagger]{baguette::bagger()}} and \code{\link[ipred:bagging]{ipred::bagging()}} create collections of decision
trees forming an ensemble. All trees in the ensemble are combined to produce
a final prediction.
}
\details{
For this engine, there are multiple modes: classification, regression,
and censored regression
\subsection{Tuning Parameters}{

This model has 4 tuning parameters:
\itemize{
\item \code{class_cost}: Class Cost (type: double, default: (see below))
\item \code{tree_depth}: Tree Depth (type: integer, default: 30L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 2L)
\item \code{cost_complexity}: Cost-Complexity Parameter (type: double, default:
0.01)
}

For the \code{class_cost} parameter, the value can be a non-negative scalar
for a class cost (where a cost of 1 means no extra cost). This is useful
for when the first level of the outcome factor is the minority class. If
this is not the case, values between zero and one can be used to bias to
the second level of the factor.
}

\subsection{Translation from parsnip to the original package (classification)}{

The \strong{baguette} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(baguette)

bag_tree(tree_depth = integer(1), min_n = integer(1), cost_complexity = double(1)) \%>\% 
  set_engine("rpart") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Bagged Decision Tree Model Specification (classification)
## 
## Main Arguments:
##   cost_complexity = double(1)
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: rpart 
## 
## Model fit template:
## baguette::bagger(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), cp = double(1), maxdepth = integer(1), 
##     minsplit = integer(1), base_model = "CART")
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (regression)}{

The \strong{baguette} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(baguette)

bag_tree(tree_depth = integer(1), min_n = integer(1), cost_complexity = double(1)) \%>\% 
  set_engine("rpart") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Bagged Decision Tree Model Specification (regression)
## 
## Main Arguments:
##   cost_complexity = double(1)
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: rpart 
## 
## Model fit template:
## baguette::bagger(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), cp = double(1), maxdepth = integer(1), 
##     minsplit = integer(1), base_model = "CART")
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (censored regression)}{

The \strong{censored} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

bag_tree(tree_depth = integer(1), min_n = integer(1), cost_complexity = double(1)) \%>\% 
  set_engine("rpart") \%>\% 
  set_mode("censored regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Bagged Decision Tree Model Specification (censored regression)
## 
## Main Arguments:
##   cost_complexity = double(1)
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: rpart 
## 
## Model fit template:
## ipred::bagging(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), cp = double(1), maxdepth = integer(1), 
##     minsplit = integer(1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Other details}{

Predictions of type \code{"time"} are predictions of the median survival
time.
}

\subsection{References}{
\itemize{
\item Breiman L. 1996. “Bagging predictors”. Machine Learning. 24 (2):
123-140
\item Hothorn T, Lausen B, Benner A, Radespiel-Troeger M. 2004. Bagging
Survival Trees. \emph{Statistics in Medicine}, 23(1), 77–91.
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
