% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_docs.R
\name{doc-tools}
\alias{doc-tools}
\alias{find_engine_files}
\alias{make_engine_list}
\alias{make_seealso_list}
\title{Tools for documenting engines}
\usage{
find_engine_files(mod)

make_engine_list(mod)

make_seealso_list(mod, pkg = "parsnip")
}
\arguments{
\item{mod}{A character string for the model file (e.g. "linear_reg")}

\item{pkg}{A character string for the package where the function is invoked.}
}
\value{
\code{make_engine_list()} returns a character string that creates a
bulleted list of links to more specific help files.

\code{make_seealso_list()} returns a formatted character string of links.

\code{find_engine_files()} returns a tibble.
}
\description{
parsnip has a fairly complex documentation system where the engines for
each model have detailed documentation about the syntax, tuning parameters,
preprocessing needs, and so on.

The functions below are called from \code{.R} files to programmatically
generate content in the help files for a model.
\itemize{
\item \code{\link[=find_engine_files]{find_engine_files()}} identifies engines for a model and creates a
bulleted list of links to those specific help files.
\item \code{\link[=make_seealso_list]{make_seealso_list()}} creates a set of links for the "See Also" list at
the bottom of the help pages.
\item \code{\link[=find_engine_files]{find_engine_files()}} is a function, used by the above, to find the
engines for each model function.
}
}
\details{
parsnip includes a document (\code{README-DOCS.md}) with step-by-step instructions
and details. See the code below to determine where it is installed (or see
the References section).

Most parsnip users will not need to use these functions or documentation.
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# See this file for step-by-step instructions.
system.file("README-DOCS.md", package = "parsnip")

# Code examples:
make_engine_list("linear_reg")

cat(make_engine_list("linear_reg"))
\dontshow{\}) # examplesIf}
}
\references{
\url{https://github.com/tidymodels/parsnip/blob/main/inst/README-DOCS.md}
}
\keyword{internal}
