% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree_mboost.R
\name{details_boost_tree_mboost}
\alias{details_boost_tree_mboost}
\title{Boosted trees}
\description{
\code{\link[mboost:blackboost]{mboost::blackboost()}} fits a series of decision trees forming an ensemble.
Each tree depends on the results of previous trees. All trees in the
ensemble are combined to produce a final prediction.
}
\details{
For this engine, there is a single mode: censored regression
\subsection{Tuning Parameters}{

This model has 5 tuning parameters:
\itemize{
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: see
below)
\item \code{trees}: # Trees (type: integer, default: 100L)
\item \code{tree_depth}: Tree Depth (type: integer, default: 2L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 10L)
\item \code{loss_reduction}: Minimum Loss Reduction (type: double, default: 0)
}

The \code{mtry} parameter is related to the number of predictors. The default
is to use all predictors.
}

\subsection{Translation from parsnip to the original package (censored regression)}{

The \strong{censored} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

boost_tree() \%>\% 
  set_engine("mboost") \%>\% 
  set_mode("censored regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Boosted Tree Model Specification (censored regression)
## 
## Computational engine: mboost 
## 
## Model fit template:
## censored::blackboost_train(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), family = mboost::CoxPH())
}\if{html}{\out{</div>}}

\code{censored::blackboost_train()} is a wrapper around
\code{\link[mboost:blackboost]{mboost::blackboost()}} (and other functions)
that makes it easier to run this model.
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Other details}{

Predictions of type \code{"time"} are predictions of the mean survival time.
}

\subsection{References}{
\itemize{
\item Buehlmann P, Hothorn T. 2007. Boosting algorithms: regularization,
prediction and model fitting. \emph{Statistical Science}, 22(4), 477–505.
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
